--------------------------------------------------------------------------
--  DLX PROCESSOR MODEL SUITE
--  Copyright (C) 1995, Martin Gumm
--  University of Stuttgart / Department of Computer Science / IPVR-ISE
--------------------------------------------------------------------------
--  This program is free software; you can redistribute it and/or modify
--  it under the terms of the GNU General Public License as published by
--  the Free Software Foundation; either version 1, or (at your option)
--  any later version.
--
--  This program is distributed in the hope that it will be useful,
--  but WITHOUT ANY WARRANTY; without even the implied warranty of
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--  GNU General Public License for more details.
--------------------------------------------------------------------------

--------------------------------------------------------------------------
--  Architecture declaration for the rom
--    generated by the DLX_ASM assembler v1.0
--    (C) v1.1 M.Gumm / (C) v0.1 P. Bazrgan Sabet
--
--  (input file: system.asm)
--  (vhdl file : rom-behaviour_system.vhd)
--------------------------------------------------------------------------

architecture behaviour_system of rom is

begin
 
-- word addressable rom (size 64Kbyte : 16 bit address)
 
  process
    variable address : natural;
  begin
    --
    -- initialize outputs
    --
    d_bus <= (others => 'Z') after tpd;
    ready <= 'Z' after tpd;
      --
      -- wait until rom is enabled
      --
      wait until Is_1H(enable);
      ready <= '0' after tpd;
      --
      -- decode address and perform command if selected
      --
      address := sv_to_natural(a_bus);
      wait for tac; 			-- read access time
      case address is
        when 16#0000# => d_bus <= To_StdLogicVector(X"6c010000");
        when 16#0004# => d_bus <= To_StdLogicVector(X"64211000");
        when 16#0008# => d_bus <= To_StdLogicVector(X"00202002");
        when 16#000c# => d_bus <= To_StdLogicVector(X"6c018000");
        when 16#0010# => d_bus <= To_StdLogicVector(X"64210000");
        when 16#0014# => d_bus <= To_StdLogicVector(X"00201002");
        when 16#0018# => d_bus <= To_StdLogicVector(X"00000808");
        when 16#001c# => d_bus <= To_StdLogicVector(X"00001008");
        when 16#0020# => d_bus <= To_StdLogicVector(X"00001808");
        when 16#0024# => d_bus <= To_StdLogicVector(X"00002008");
        when 16#0028# => d_bus <= To_StdLogicVector(X"00002808");
        when 16#002c# => d_bus <= To_StdLogicVector(X"00003008");
        when 16#0030# => d_bus <= To_StdLogicVector(X"00003808");
        when 16#0034# => d_bus <= To_StdLogicVector(X"00004008");
        when 16#0038# => d_bus <= To_StdLogicVector(X"00004808");
        when 16#003c# => d_bus <= To_StdLogicVector(X"00005008");
        when 16#0040# => d_bus <= To_StdLogicVector(X"00005808");
        when 16#0044# => d_bus <= To_StdLogicVector(X"00006008");
        when 16#0048# => d_bus <= To_StdLogicVector(X"00006808");
        when 16#004c# => d_bus <= To_StdLogicVector(X"00007008");
        when 16#0050# => d_bus <= To_StdLogicVector(X"00007808");
        when 16#0054# => d_bus <= To_StdLogicVector(X"00008008");
        when 16#0058# => d_bus <= To_StdLogicVector(X"00008808");
        when 16#005c# => d_bus <= To_StdLogicVector(X"00009008");
        when 16#0060# => d_bus <= To_StdLogicVector(X"00009808");
        when 16#0064# => d_bus <= To_StdLogicVector(X"0000a008");
        when 16#0068# => d_bus <= To_StdLogicVector(X"0000a808");
        when 16#006c# => d_bus <= To_StdLogicVector(X"0000b008");
        when 16#0070# => d_bus <= To_StdLogicVector(X"0000b808");
        when 16#0074# => d_bus <= To_StdLogicVector(X"0000c008");
        when 16#0078# => d_bus <= To_StdLogicVector(X"0000c808");
        when 16#007c# => d_bus <= To_StdLogicVector(X"0000d008");
        when 16#0080# => d_bus <= To_StdLogicVector(X"0000d808");
        when 16#0084# => d_bus <= To_StdLogicVector(X"0000e008");
        when 16#0088# => d_bus <= To_StdLogicVector(X"0000e808");
        when 16#008c# => d_bus <= To_StdLogicVector(X"0000f008");
        when 16#0090# => d_bus <= To_StdLogicVector(X"0000f808");
        when 16#0094# => d_bus <= To_StdLogicVector(X"48000000");
        when 16#1000# => d_bus <= To_StdLogicVector(X"0020f003");
        when 16#1004# => d_bus <= To_StdLogicVector(X"63de00fe");
        when 16#1008# => d_bus <= To_StdLogicVector(X"47c00078");
        when 16#100c# => d_bus <= To_StdLogicVector(X"0020f003");
        when 16#1010# => d_bus <= To_StdLogicVector(X"7bde001c");
        when 16#1014# => d_bus <= To_StdLogicVector(X"9bdd0001");
        when 16#1018# => d_bus <= To_StdLogicVector(X"43a00004");
        when 16#101c# => d_bus <= To_StdLogicVector(X"3000004c");
        when 16#1020# => d_bus <= To_StdLogicVector(X"9bdd0002");
        when 16#1024# => d_bus <= To_StdLogicVector(X"43a00004");
        when 16#1028# => d_bus <= To_StdLogicVector(X"30000040");
        when 16#102c# => d_bus <= To_StdLogicVector(X"9bdd0004");
        when 16#1030# => d_bus <= To_StdLogicVector(X"43a0001c");
        when 16#1034# => d_bus <= To_StdLogicVector(X"6c1e7000");
        when 16#1038# => d_bus <= To_StdLogicVector(X"13dd0000");
        when 16#103c# => d_bus <= To_StdLogicVector(X"501c0015");
        when 16#1040# => d_bus <= To_StdLogicVector(X"739c001a");
        when 16#1044# => d_bus <= To_StdLogicVector(X"03bce80a");
        when 16#1048# => d_bus <= To_StdLogicVector(X"23dd0000");
        when 16#104c# => d_bus <= To_StdLogicVector(X"3000001c");
        when 16#1050# => d_bus <= To_StdLogicVector(X"6c1e7000");
        when 16#1054# => d_bus <= To_StdLogicVector(X"13dd0000");
        when 16#1058# => d_bus <= To_StdLogicVector(X"501c0015");
        when 16#105c# => d_bus <= To_StdLogicVector(X"739c001b");
        when 16#1060# => d_bus <= To_StdLogicVector(X"03bce80a");
        when 16#1064# => d_bus <= To_StdLogicVector(X"23dd0000");
        when 16#1068# => d_bus <= To_StdLogicVector(X"30000000");
        when 16#106c# => d_bus <= To_StdLogicVector(X"0020f003");
        when 16#1070# => d_bus <= To_StdLogicVector(X"501dffff");
        when 16#1074# => d_bus <= To_StdLogicVector(X"7bbd0004");
        when 16#1078# => d_bus <= To_StdLogicVector(X"03ddf008");
        when 16#107c# => d_bus <= To_StdLogicVector(X"03c00802");
        when 16#1080# => d_bus <= To_StdLogicVector(X"48000000");
        when 16#1084# => d_bus <= To_StdLogicVector(X"83dd0002");
        when 16#1088# => d_bus <= To_StdLogicVector(X"43a00004");
        when 16#108c# => d_bus <= To_StdLogicVector(X"30006f70");
        when 16#1090# => d_bus <= To_StdLogicVector(X"9bdd0004");
        when 16#1094# => d_bus <= To_StdLogicVector(X"43a00004");
        when 16#1098# => d_bus <= To_StdLogicVector(X"30006f64");
        when 16#109c# => d_bus <= To_StdLogicVector(X"9bdd0008");
        when 16#10a0# => d_bus <= To_StdLogicVector(X"43a00004");
        when 16#10a4# => d_bus <= To_StdLogicVector(X"30006f58");
        when 16#10a8# => d_bus <= To_StdLogicVector(X"9bdd0010");
        when 16#10ac# => d_bus <= To_StdLogicVector(X"43a00004");
        when 16#10b0# => d_bus <= To_StdLogicVector(X"30006f4c");
        when 16#10b4# => d_bus <= To_StdLogicVector(X"9bdd0020");
        when 16#10b8# => d_bus <= To_StdLogicVector(X"43a00004");
        when 16#10bc# => d_bus <= To_StdLogicVector(X"30006f40");
        when 16#10c0# => d_bus <= To_StdLogicVector(X"83dd0080");
        when 16#10c4# => d_bus <= To_StdLogicVector(X"43a00004");
        when 16#10c8# => d_bus <= To_StdLogicVector(X"30006f34");
        when 16#10cc# => d_bus <= To_StdLogicVector(X"48000000");
        when 16#8000# => d_bus <= To_StdLogicVector(X"00000000");
        when 16#8004# => d_bus <= To_StdLogicVector(X"33ff90c4");
        when 16#2000# => d_bus <= To_StdLogicVector(X"0040f003");
        when 16#2004# => d_bus <= To_StdLogicVector(X"03c0e809");
        when 16#2008# => d_bus <= To_StdLogicVector(X"03a01002");
        when 16#200c# => d_bus <= To_StdLogicVector(X"48000000");
        when 16#3000# => d_bus <= To_StdLogicVector(X"6c1e7000");
        when 16#3004# => d_bus <= To_StdLogicVector(X"6c1d0100");
        when 16#3008# => d_bus <= To_StdLogicVector(X"23dd0000");
        when 16#300c# => d_bus <= To_StdLogicVector(X"48000000");
        when 16#3100# => d_bus <= To_StdLogicVector(X"6c1e7000");
        when 16#3104# => d_bus <= To_StdLogicVector(X"73bd0010");
        when 16#3108# => d_bus <= To_StdLogicVector(X"23dd0004");
        when 16#310c# => d_bus <= To_StdLogicVector(X"48000000");
        when 16#3200# => d_bus <= To_StdLogicVector(X"6c1e7000");
        when 16#3204# => d_bus <= To_StdLogicVector(X"73bd0010");
        when 16#3208# => d_bus <= To_StdLogicVector(X"23dd0008");
        when 16#320c# => d_bus <= To_StdLogicVector(X"48000000");
        when 16#3300# => d_bus <= To_StdLogicVector(X"6c1d0f00");
        when 16#3304# => d_bus <= To_StdLogicVector(X"0020f003");
        when 16#3308# => d_bus <= To_StdLogicVector(X"03ddf009");
        when 16#330c# => d_bus <= To_StdLogicVector(X"03c00802");
        when 16#3310# => d_bus <= To_StdLogicVector(X"48000000");
        when 16#3400# => d_bus <= To_StdLogicVector(X"6c1e7000");
        when 16#3404# => d_bus <= To_StdLogicVector(X"6c1d3c00");
        when 16#3408# => d_bus <= To_StdLogicVector(X"23dd0000");
        when 16#340c# => d_bus <= To_StdLogicVector(X"48000000");
        when others   => d_bus <= (others => 'X');
      end case;
      ready <= '1' after tpd;
      --
      -- wait for acceptance of data
      --
      wait until Is_0L(enable);
 
  end process;
 
end behaviour_system;
