--------------------------------------------------------------------------
--  DLX PROCESSOR MODEL SUITE
--  Copyright (C) 1995, Martin Gumm
--  University of Stuttgart / Department of Computer Science / IPVR-ISE
--------------------------------------------------------------------------
--  This program is free software; you can redistribute it and/or modify
--  it under the terms of the GNU General Public License as published by
--  the Free Software Foundation; either version 1, or (at your option)
--  any later version.
--
--  This program is distributed in the hope that it will be useful,
--  but WITHOUT ANY WARRANTY; without even the implied warranty of
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--  GNU General Public License for more details.
--------------------------------------------------------------------------

--------------------------------------------------------------------------
--  Architecture declaration for the rom
--    generated by the DLX_ASM assembler v1.0
--    (C) v1.1 M.Gumm / (C) v0.1 P. Bazrgan Sabet
--
--  (input file: set1.asm)
--  (vhdl file : rom-behaviour_set1.vhd)
--------------------------------------------------------------------------

architecture behaviour_set1 of rom is

begin
 
-- word addressable rom (size 64Kbyte : 16 bit address)
 
  process
    variable address : natural;
  begin
    --
    -- initialize outputs
    --
    d_bus <= (others => 'Z') after tpd;
    ready <= 'Z' after tpd;
      --
      -- wait until rom is enabled
      --
      wait until Is_1H(enable);
      ready <= '0' after tpd;
      --
      -- decode address and perform command if selected
      --
      address := sv_to_natural(a_bus);
      wait for tac; 			-- read access time
      case address is
        when 16#0000# => d_bus <= To_StdLogicVector(X"50010002");
        when 16#0004# => d_bus <= To_StdLogicVector(X"50020003");
        when 16#0008# => d_bus <= To_StdLogicVector(X"5003fffe");
        when 16#000c# => d_bus <= To_StdLogicVector(X"5004fffd");
        when 16#0010# => d_bus <= To_StdLogicVector(X"00213810");
        when 16#0014# => d_bus <= To_StdLogicVector(X"40e00fe8");
        when 16#0018# => d_bus <= To_StdLogicVector(X"80470003");
        when 16#001c# => d_bus <= To_StdLogicVector(X"40e00fe0");
        when 16#0020# => d_bus <= To_StdLogicVector(X"00633812");
        when 16#0024# => d_bus <= To_StdLogicVector(X"44e00fd8");
        when 16#0028# => d_bus <= To_StdLogicVector(X"8887fffd");
        when 16#002c# => d_bus <= To_StdLogicVector(X"44e00fd0");
        when 16#0030# => d_bus <= To_StdLogicVector(X"00223818");
        when 16#0034# => d_bus <= To_StdLogicVector(X"44e00fc8");
        when 16#0038# => d_bus <= To_StdLogicVector(X"00233818");
        when 16#003c# => d_bus <= To_StdLogicVector(X"40e00fc0");
        when 16#0040# => d_bus <= To_StdLogicVector(X"00413818");
        when 16#0044# => d_bus <= To_StdLogicVector(X"40e00fb8");
        when 16#0048# => d_bus <= To_StdLogicVector(X"00643818");
        when 16#004c# => d_bus <= To_StdLogicVector(X"40e00fb0");
        when 16#0050# => d_bus <= To_StdLogicVector(X"00833818");
        when 16#0054# => d_bus <= To_StdLogicVector(X"44e00fa8");
        when 16#0058# => d_bus <= To_StdLogicVector(X"a0270003");
        when 16#005c# => d_bus <= To_StdLogicVector(X"44e00fa0");
        when 16#0060# => d_bus <= To_StdLogicVector(X"a027fffe");
        when 16#0064# => d_bus <= To_StdLogicVector(X"40e00f98");
        when 16#0068# => d_bus <= To_StdLogicVector(X"a0470002");
        when 16#006c# => d_bus <= To_StdLogicVector(X"40e00f90");
        when 16#0070# => d_bus <= To_StdLogicVector(X"a067fffd");
        when 16#0074# => d_bus <= To_StdLogicVector(X"40e00f88");
        when 16#0078# => d_bus <= To_StdLogicVector(X"a087fffe");
        when 16#007c# => d_bus <= To_StdLogicVector(X"44e00f80");
        when 16#0080# => d_bus <= To_StdLogicVector(X"00223814");
        when 16#0084# => d_bus <= To_StdLogicVector(X"40e00f78");
        when 16#0088# => d_bus <= To_StdLogicVector(X"00233814");
        when 16#008c# => d_bus <= To_StdLogicVector(X"44e00f70");
        when 16#0090# => d_bus <= To_StdLogicVector(X"00413814");
        when 16#0094# => d_bus <= To_StdLogicVector(X"44e00f68");
        when 16#0098# => d_bus <= To_StdLogicVector(X"00643814");
        when 16#009c# => d_bus <= To_StdLogicVector(X"44e00f60");
        when 16#00a0# => d_bus <= To_StdLogicVector(X"00833814");
        when 16#00a4# => d_bus <= To_StdLogicVector(X"40e00f58");
        when 16#00a8# => d_bus <= To_StdLogicVector(X"90270003");
        when 16#00ac# => d_bus <= To_StdLogicVector(X"40e00f50");
        when 16#00b0# => d_bus <= To_StdLogicVector(X"9027fffe");
        when 16#00b4# => d_bus <= To_StdLogicVector(X"44e00f48");
        when 16#00b8# => d_bus <= To_StdLogicVector(X"90470002");
        when 16#00bc# => d_bus <= To_StdLogicVector(X"44e00f40");
        when 16#00c0# => d_bus <= To_StdLogicVector(X"9067fffd");
        when 16#00c4# => d_bus <= To_StdLogicVector(X"44e00f38");
        when 16#00c8# => d_bus <= To_StdLogicVector(X"9087fffe");
        when 16#00cc# => d_bus <= To_StdLogicVector(X"40e00f30");
        when 16#00d0# => d_bus <= To_StdLogicVector(X"0022381a");
        when 16#00d4# => d_bus <= To_StdLogicVector(X"44e00f28");
        when 16#00d8# => d_bus <= To_StdLogicVector(X"0021381a");
        when 16#00dc# => d_bus <= To_StdLogicVector(X"40e00f20");
        when 16#00e0# => d_bus <= To_StdLogicVector(X"0023381a");
        when 16#00e4# => d_bus <= To_StdLogicVector(X"40e00f18");
        when 16#00e8# => d_bus <= To_StdLogicVector(X"0041381a");
        when 16#00ec# => d_bus <= To_StdLogicVector(X"40e00f10");
        when 16#00f0# => d_bus <= To_StdLogicVector(X"0064381a");
        when 16#00f4# => d_bus <= To_StdLogicVector(X"40e00f08");
        when 16#00f8# => d_bus <= To_StdLogicVector(X"0083381a");
        when 16#00fc# => d_bus <= To_StdLogicVector(X"44e00f00");
        when 16#0100# => d_bus <= To_StdLogicVector(X"a8270003");
        when 16#0104# => d_bus <= To_StdLogicVector(X"44e00ef8");
        when 16#0108# => d_bus <= To_StdLogicVector(X"a8270002");
        when 16#010c# => d_bus <= To_StdLogicVector(X"40e00ef0");
        when 16#0110# => d_bus <= To_StdLogicVector(X"a827fffe");
        when 16#0114# => d_bus <= To_StdLogicVector(X"40e00ee8");
        when 16#0118# => d_bus <= To_StdLogicVector(X"a8470002");
        when 16#011c# => d_bus <= To_StdLogicVector(X"40e00ee0");
        when 16#0120# => d_bus <= To_StdLogicVector(X"a867fffd");
        when 16#0124# => d_bus <= To_StdLogicVector(X"40e00ed8");
        when 16#0128# => d_bus <= To_StdLogicVector(X"a887fffe");
        when 16#012c# => d_bus <= To_StdLogicVector(X"44e00ed0");
        when 16#0130# => d_bus <= To_StdLogicVector(X"00223816");
        when 16#0134# => d_bus <= To_StdLogicVector(X"40e00ec8");
        when 16#0138# => d_bus <= To_StdLogicVector(X"00213816");
        when 16#013c# => d_bus <= To_StdLogicVector(X"40e00ec0");
        when 16#0140# => d_bus <= To_StdLogicVector(X"00233816");
        when 16#0144# => d_bus <= To_StdLogicVector(X"44e00eb8");
        when 16#0148# => d_bus <= To_StdLogicVector(X"00413816");
        when 16#014c# => d_bus <= To_StdLogicVector(X"44e00eb0");
        when 16#0150# => d_bus <= To_StdLogicVector(X"00643816");
        when 16#0154# => d_bus <= To_StdLogicVector(X"44e00ea8");
        when 16#0158# => d_bus <= To_StdLogicVector(X"00833816");
        when 16#015c# => d_bus <= To_StdLogicVector(X"40e00ea0");
        when 16#0160# => d_bus <= To_StdLogicVector(X"98270003");
        when 16#0164# => d_bus <= To_StdLogicVector(X"40e00e98");
        when 16#0168# => d_bus <= To_StdLogicVector(X"98270002");
        when 16#016c# => d_bus <= To_StdLogicVector(X"40e00e90");
        when 16#0170# => d_bus <= To_StdLogicVector(X"9827fffe");
        when 16#0174# => d_bus <= To_StdLogicVector(X"44e00e88");
        when 16#0178# => d_bus <= To_StdLogicVector(X"98470002");
        when 16#017c# => d_bus <= To_StdLogicVector(X"44e00e80");
        when 16#0180# => d_bus <= To_StdLogicVector(X"9867fffd");
        when 16#0184# => d_bus <= To_StdLogicVector(X"44e00e78");
        when 16#0188# => d_bus <= To_StdLogicVector(X"9887fffe");
        when 16#018c# => d_bus <= To_StdLogicVector(X"40e00e70");
        when 16#0190# => d_bus <= To_StdLogicVector(X"30001e6c");
        when 16#1000# => d_bus <= To_StdLogicVector(X"00000000");
        when 16#1004# => d_bus <= To_StdLogicVector(X"33fffff8");
        when 16#2000# => d_bus <= To_StdLogicVector(X"33fffffc");
        when others   => d_bus <= (others => 'X');
      end case;
      ready <= '1' after tpd;
      --
      -- wait for acceptance of data
      --
      wait until Is_0L(enable);
 
  end process;
 
end behaviour_set1;
