--------------------------------------------------------------------------
--  DLX PROCESSOR MODEL SUITE
--  Copyright (C) 1995, Martin Gumm
--  University of Stuttgart / Department of Computer Science / IPVR-ISE
--------------------------------------------------------------------------
--  This program is free software; you can redistribute it and/or modify
--  it under the terms of the GNU General Public License as published by
--  the Free Software Foundation; either version 1, or (at your option)
--  any later version.
--
--  This program is distributed in the hope that it will be useful,
--  but WITHOUT ANY WARRANTY; without even the implied warranty of
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--  GNU General Public License for more details.
--------------------------------------------------------------------------

--------------------------------------------------------------------------
--  Architecture declaration for the rom
--    generated by the DLX_ASM assembler v1.0
--    (C) v1.1 M.Gumm / (C) v0.1 P. Bazrgan Sabet
--
--  (input file: loadstore_s.asm)
--  (vhdl file : rom-behaviour_loadstore.vhd)
--------------------------------------------------------------------------

architecture behaviour_loadstore of rom is

begin
 
-- word addressable rom (size 64Kbyte : 16 bit address)
 
  process
    variable address : natural;
  begin
    --
    -- initialize outputs
    --
    d_bus <= (others => 'Z') after tpd;
    ready <= 'Z' after tpd;
      --
      -- wait until rom is enabled
      --
      wait until Is_1H(enable);
      ready <= '0' after tpd;
      --
      -- decode address and perform command if selected
      --
      address := sv_to_natural(a_bus);
      wait for tac; 			-- read access time
      case address is
        when 16#0000# => d_bus <= To_StdLogicVector(X"6c1d8fff");
        when 16#0004# => d_bus <= To_StdLogicVector(X"67bdfff0");
        when 16#0008# => d_bus <= To_StdLogicVector(X"6c1e9000");
        when 16#000c# => d_bus <= To_StdLogicVector(X"67de0000");
        when 16#0010# => d_bus <= To_StdLogicVector(X"6c010123");
        when 16#0014# => d_bus <= To_StdLogicVector(X"64214567");
        when 16#0018# => d_bus <= To_StdLogicVector(X"23a10010");
        when 16#001c# => d_bus <= To_StdLogicVector(X"13c20000");
        when 16#0020# => d_bus <= To_StdLogicVector(X"00221810");
        when 16#0024# => d_bus <= To_StdLogicVector(X"44600008");
        when 16#0028# => d_bus <= To_StdLogicVector(X"00000000");
        when 16#002c# => d_bus <= To_StdLogicVector(X"33fffff8");
        when 16#0030# => d_bus <= To_StdLogicVector(X"6c01ff00");
        when 16#0034# => d_bus <= To_StdLogicVector(X"642100ff");
        when 16#0038# => d_bus <= To_StdLogicVector(X"501b0014");
        when 16#003c# => d_bus <= To_StdLogicVector(X"501c0004");
        when 16#0040# => d_bus <= To_StdLogicVector(X"03bb0828");
        when 16#0044# => d_bus <= To_StdLogicVector(X"03dc1020");
        when 16#0048# => d_bus <= To_StdLogicVector(X"00221810");
        when 16#004c# => d_bus <= To_StdLogicVector(X"44600008");
        when 16#0050# => d_bus <= To_StdLogicVector(X"00000000");
        when 16#0054# => d_bus <= To_StdLogicVector(X"33fffff8");
        when 16#0058# => d_bus <= To_StdLogicVector(X"64017fff");
        when 16#005c# => d_bus <= To_StdLogicVector(X"6402fa51");
        when 16#0060# => d_bus <= To_StdLogicVector(X"27a10018");
        when 16#0064# => d_bus <= To_StdLogicVector(X"27a2001a");
        when 16#0068# => d_bus <= To_StdLogicVector(X"17c30008");
        when 16#006c# => d_bus <= To_StdLogicVector(X"17c4000a");
        when 16#0070# => d_bus <= To_StdLogicVector(X"6c050000");
        when 16#0074# => d_bus <= To_StdLogicVector(X"64a57fff");
        when 16#0078# => d_bus <= To_StdLogicVector(X"6c06ffff");
        when 16#007c# => d_bus <= To_StdLogicVector(X"64c6fa51");
        when 16#0080# => d_bus <= To_StdLogicVector(X"00a33810");
        when 16#0084# => d_bus <= To_StdLogicVector(X"40e00008");
        when 16#0088# => d_bus <= To_StdLogicVector(X"00c43810");
        when 16#008c# => d_bus <= To_StdLogicVector(X"44e00008");
        when 16#0090# => d_bus <= To_StdLogicVector(X"00000000");
        when 16#0094# => d_bus <= To_StdLogicVector(X"33fffff8");
        when 16#0098# => d_bus <= To_StdLogicVector(X"64016af1");
        when 16#009c# => d_bus <= To_StdLogicVector(X"64028001");
        when 16#00a0# => d_bus <= To_StdLogicVector(X"6418001c");
        when 16#00a4# => d_bus <= To_StdLogicVector(X"6419001e");
        when 16#00a8# => d_bus <= To_StdLogicVector(X"641a000c");
        when 16#00ac# => d_bus <= To_StdLogicVector(X"641b000e");
        when 16#00b0# => d_bus <= To_StdLogicVector(X"03b80829");
        when 16#00b4# => d_bus <= To_StdLogicVector(X"03b91029");
        when 16#00b8# => d_bus <= To_StdLogicVector(X"03da1821");
        when 16#00bc# => d_bus <= To_StdLogicVector(X"03db2021");
        when 16#00c0# => d_bus <= To_StdLogicVector(X"6c050000");
        when 16#00c4# => d_bus <= To_StdLogicVector(X"64a56af1");
        when 16#00c8# => d_bus <= To_StdLogicVector(X"6c06ffff");
        when 16#00cc# => d_bus <= To_StdLogicVector(X"64c68001");
        when 16#00d0# => d_bus <= To_StdLogicVector(X"00a33810");
        when 16#00d4# => d_bus <= To_StdLogicVector(X"40e00008");
        when 16#00d8# => d_bus <= To_StdLogicVector(X"00c43810");
        when 16#00dc# => d_bus <= To_StdLogicVector(X"44e00008");
        when 16#00e0# => d_bus <= To_StdLogicVector(X"00000000");
        when 16#00e4# => d_bus <= To_StdLogicVector(X"33ffff68");
        when 16#00e8# => d_bus <= To_StdLogicVector(X"64010023");
        when 16#00ec# => d_bus <= To_StdLogicVector(X"6402007f");
        when 16#00f0# => d_bus <= To_StdLogicVector(X"640300ab");
        when 16#00f4# => d_bus <= To_StdLogicVector(X"640400fe");
        when 16#00f8# => d_bus <= To_StdLogicVector(X"2ba10020");
        when 16#00fc# => d_bus <= To_StdLogicVector(X"2ba20021");
        when 16#0100# => d_bus <= To_StdLogicVector(X"2ba30022");
        when 16#0104# => d_bus <= To_StdLogicVector(X"2ba40023");
        when 16#0108# => d_bus <= To_StdLogicVector(X"1bc50010");
        when 16#010c# => d_bus <= To_StdLogicVector(X"1bc60011");
        when 16#0110# => d_bus <= To_StdLogicVector(X"1bc70012");
        when 16#0114# => d_bus <= To_StdLogicVector(X"1bc80013");
        when 16#0118# => d_bus <= To_StdLogicVector(X"6c090000");
        when 16#011c# => d_bus <= To_StdLogicVector(X"65290023");
        when 16#0120# => d_bus <= To_StdLogicVector(X"6c0a0000");
        when 16#0124# => d_bus <= To_StdLogicVector(X"654a007f");
        when 16#0128# => d_bus <= To_StdLogicVector(X"6c0bffff");
        when 16#012c# => d_bus <= To_StdLogicVector(X"656bffab");
        when 16#0130# => d_bus <= To_StdLogicVector(X"6c0cffff");
        when 16#0134# => d_bus <= To_StdLogicVector(X"658cfffe");
        when 16#0138# => d_bus <= To_StdLogicVector(X"00a96810");
        when 16#013c# => d_bus <= To_StdLogicVector(X"41a00018");
        when 16#0140# => d_bus <= To_StdLogicVector(X"00ca6810");
        when 16#0144# => d_bus <= To_StdLogicVector(X"41a00010");
        when 16#0148# => d_bus <= To_StdLogicVector(X"00eb6810");
        when 16#014c# => d_bus <= To_StdLogicVector(X"41a00008");
        when 16#0150# => d_bus <= To_StdLogicVector(X"010c6810");
        when 16#0154# => d_bus <= To_StdLogicVector(X"45a00008");
        when 16#0158# => d_bus <= To_StdLogicVector(X"00000000");
        when 16#015c# => d_bus <= To_StdLogicVector(X"33ffff30");
        when 16#0160# => d_bus <= To_StdLogicVector(X"6401003c");
        when 16#0164# => d_bus <= To_StdLogicVector(X"64020060");
        when 16#0168# => d_bus <= To_StdLogicVector(X"640300cc");
        when 16#016c# => d_bus <= To_StdLogicVector(X"64040099");
        when 16#0170# => d_bus <= To_StdLogicVector(X"64140024");
        when 16#0174# => d_bus <= To_StdLogicVector(X"64150025");
        when 16#0178# => d_bus <= To_StdLogicVector(X"64160026");
        when 16#017c# => d_bus <= To_StdLogicVector(X"64170027");
        when 16#0180# => d_bus <= To_StdLogicVector(X"64180014");
        when 16#0184# => d_bus <= To_StdLogicVector(X"64190015");
        when 16#0188# => d_bus <= To_StdLogicVector(X"641a0016");
        when 16#018c# => d_bus <= To_StdLogicVector(X"641b0017");
        when 16#0190# => d_bus <= To_StdLogicVector(X"03b4082a");
        when 16#0194# => d_bus <= To_StdLogicVector(X"03b5102a");
        when 16#0198# => d_bus <= To_StdLogicVector(X"03b6182a");
        when 16#019c# => d_bus <= To_StdLogicVector(X"03b7202a");
        when 16#01a0# => d_bus <= To_StdLogicVector(X"03d82822");
        when 16#01a4# => d_bus <= To_StdLogicVector(X"03d93022");
        when 16#01a8# => d_bus <= To_StdLogicVector(X"03da3822");
        when 16#01ac# => d_bus <= To_StdLogicVector(X"03db4022");
        when 16#01b0# => d_bus <= To_StdLogicVector(X"6c090000");
        when 16#01b4# => d_bus <= To_StdLogicVector(X"6529003c");
        when 16#01b8# => d_bus <= To_StdLogicVector(X"6c0a0000");
        when 16#01bc# => d_bus <= To_StdLogicVector(X"654a0060");
        when 16#01c0# => d_bus <= To_StdLogicVector(X"6c0bffff");
        when 16#01c4# => d_bus <= To_StdLogicVector(X"656bffcc");
        when 16#01c8# => d_bus <= To_StdLogicVector(X"6c0cffff");
        when 16#01cc# => d_bus <= To_StdLogicVector(X"658cff99");
        when 16#01d0# => d_bus <= To_StdLogicVector(X"00a96810");
        when 16#01d4# => d_bus <= To_StdLogicVector(X"41a0ff80");
        when 16#01d8# => d_bus <= To_StdLogicVector(X"00ca6810");
        when 16#01dc# => d_bus <= To_StdLogicVector(X"41a0ff78");
        when 16#01e0# => d_bus <= To_StdLogicVector(X"00eb6810");
        when 16#01e4# => d_bus <= To_StdLogicVector(X"41a0ff70");
        when 16#01e8# => d_bus <= To_StdLogicVector(X"010c6810");
        when 16#01ec# => d_bus <= To_StdLogicVector(X"45a00008");
        when 16#01f0# => d_bus <= To_StdLogicVector(X"00000000");
        when 16#01f4# => d_bus <= To_StdLogicVector(X"33fffff8");
        when 16#01f8# => d_bus <= To_StdLogicVector(X"33fffe04");
        when others   => d_bus <= (others => 'X');
      end case;
      ready <= '1' after tpd;
      --
      -- wait for acceptance of data
      --
      wait until Is_0L(enable);
 
  end process;
 
end behaviour_loadstore;
