--------------------------------------------------------------------------
--  DLX PROCESSOR MODEL SUITE
--  Copyright (C) 1995, Martin Gumm
--  University of Stuttgart / Department of Computer Science / IPVR-ISE
--------------------------------------------------------------------------
--  This program is free software; you can redistribute it and/or modify
--  it under the terms of the GNU General Public License as published by
--  the Free Software Foundation; either version 1, or (at your option)
--  any later version.
--
--  This program is distributed in the hope that it will be useful,
--  but WITHOUT ANY WARRANTY; without even the implied warranty of
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--  GNU General Public License for more details.
--------------------------------------------------------------------------

--------------------------------------------------------------------------
--  Architecture declaration for the rom
--    generated by the DLX_ASM assembler v1.0
--    (C) v1.1 M.Gumm / (C) v0.1 P. Bazrgan Sabet
--
--  (input file: arith1.asm)
--  (vhdl file : rom-behaviour_arith1.vhd)
--------------------------------------------------------------------------

architecture behaviour_arith1 of rom is

begin
 
-- word addressable rom (size 64Kbyte : 16 bit address)
 
  process
    variable address : natural;
  begin
    --
    -- initialize outputs
    --
    d_bus <= (others => 'Z') after tpd;
    ready <= 'Z' after tpd;
      --
      -- wait until rom is enabled
      --
      wait until Is_1H(enable);
      ready <= '0' after tpd;
      --
      -- decode address and perform command if selected
      --
      address := sv_to_natural(a_bus);
      wait for tac; 			-- read access time
      case address is
        when 16#0000# => d_bus <= To_StdLogicVector(X"50010005");
        when 16#0004# => d_bus <= To_StdLogicVector(X"50027ff0");
        when 16#0008# => d_bus <= To_StdLogicVector(X"5003fff0");
        when 16#000c# => d_bus <= To_StdLogicVector(X"50048000");
        when 16#0010# => d_bus <= To_StdLogicVector(X"00224004");
        when 16#0014# => d_bus <= To_StdLogicVector(X"81097ff5");
        when 16#0018# => d_bus <= To_StdLogicVector(X"41200fe4");
        when 16#001c# => d_bus <= To_StdLogicVector(X"01034004");
        when 16#0020# => d_bus <= To_StdLogicVector(X"81097fe5");
        when 16#0024# => d_bus <= To_StdLogicVector(X"41200fd8");
        when 16#0028# => d_bus <= To_StdLogicVector(X"01044004");
        when 16#002c# => d_bus <= To_StdLogicVector(X"8109ffe5");
        when 16#0030# => d_bus <= To_StdLogicVector(X"41200fcc");
        when 16#0034# => d_bus <= To_StdLogicVector(X"50287ff0");
        when 16#0038# => d_bus <= To_StdLogicVector(X"81097ff5");
        when 16#003c# => d_bus <= To_StdLogicVector(X"41200fc0");
        when 16#0040# => d_bus <= To_StdLogicVector(X"5108fff0");
        when 16#0044# => d_bus <= To_StdLogicVector(X"81097fe5");
        when 16#0048# => d_bus <= To_StdLogicVector(X"41200fb4");
        when 16#004c# => d_bus <= To_StdLogicVector(X"51088000");
        when 16#0050# => d_bus <= To_StdLogicVector(X"8109ffe5");
        when 16#0054# => d_bus <= To_StdLogicVector(X"41200fa8");
        when 16#0058# => d_bus <= To_StdLogicVector(X"00224006");
        when 16#005c# => d_bus <= To_StdLogicVector(X"81098015");
        when 16#0060# => d_bus <= To_StdLogicVector(X"41200f9c");
        when 16#0064# => d_bus <= To_StdLogicVector(X"01034006");
        when 16#0068# => d_bus <= To_StdLogicVector(X"81098025");
        when 16#006c# => d_bus <= To_StdLogicVector(X"41200f90");
        when 16#0070# => d_bus <= To_StdLogicVector(X"01044006");
        when 16#0074# => d_bus <= To_StdLogicVector(X"81090025");
        when 16#0078# => d_bus <= To_StdLogicVector(X"41200f84");
        when 16#007c# => d_bus <= To_StdLogicVector(X"58287ff0");
        when 16#0080# => d_bus <= To_StdLogicVector(X"81098015");
        when 16#0084# => d_bus <= To_StdLogicVector(X"41200f78");
        when 16#0088# => d_bus <= To_StdLogicVector(X"5908fff0");
        when 16#008c# => d_bus <= To_StdLogicVector(X"81098025");
        when 16#0090# => d_bus <= To_StdLogicVector(X"41200f6c");
        when 16#0094# => d_bus <= To_StdLogicVector(X"59088000");
        when 16#0098# => d_bus <= To_StdLogicVector(X"81090025");
        when 16#009c# => d_bus <= To_StdLogicVector(X"41200f60");
        when 16#00a0# => d_bus <= To_StdLogicVector(X"30001f5c");
        when 16#1000# => d_bus <= To_StdLogicVector(X"00000000");
        when 16#1004# => d_bus <= To_StdLogicVector(X"33fffff8");
        when 16#2000# => d_bus <= To_StdLogicVector(X"33fffffc");
        when others   => d_bus <= (others => 'X');
      end case;
      ready <= '1' after tpd;
      --
      -- wait for acceptance of data
      --
      wait until Is_0L(enable);
 
  end process;
 
end behaviour_arith1;
