--------------------------------------------------------------------------
--  DLX PROCESSOR MODEL SUITE
--  Copyright (C) 1995, Martin Gumm
--  University of Stuttgart / Department of Computer Science / IPVR-ISE
--------------------------------------------------------------------------
--  This program is free software; you can redistribute it and/or modify
--  it under the terms of the GNU General Public License as published by
--  the Free Software Foundation; either version 1, or (at your option)
--  any later version.
--
--  This program is distributed in the hope that it will be useful,
--  but WITHOUT ANY WARRANTY; without even the implied warranty of
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--  GNU General Public License for more details.
--------------------------------------------------------------------------
--  Last revision date : November 15 1995
--------------------------------------------------------------------------

--------------------------------------------------------------------------
--  Entity declaration for the ram_byte module
--  
--  (file ram_byte.vhd)
--------------------------------------------------------------------------

library IEEE;
USE IEEE.std_logic_1164.ALL;
library IEEE_EXTD;
use IEEE_EXTD.stdl1164_vector_arithmetic.sv_to_natural,
    IEEE_EXTD.stdl1164_extended.all;
library DLX;
use DLX.dlx_types.all;

entity ram_byte is
  generic (b_tpd : Time;		-- signal to output delay
           b_tac : Time;		-- Access time to and from memory
           b_mem_size: natural);	-- Memory size in bytes
  port (b_a_bus : in std_logic_vector(15 downto 2);
        b_d_bus : inout dlx_byte bus;
	b_enable: in std_logic;
        b_rw    : in std_logic;
	b_ready : out std_logic);
end ram_byte;








