--------------------------------------------------------------------------
--  DLX PROCESSOR MODEL SUITE
--  Copyright (C) 1995, Martin Gumm
--  University of Stuttgart / Department of Computer Science / IPVR-ISE
--------------------------------------------------------------------------
--  This program is free software; you can redistribute it and/or modify
--  it under the terms of the GNU General Public License as published by
--  the Free Software Foundation; either version 1, or (at your option)
--  any later version.
--
--  This program is distributed in the hope that it will be useful,
--  but WITHOUT ANY WARRANTY; without even the implied warranty of
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--  GNU General Public License for more details.
--------------------------------------------------------------------------
--  Last revision date : November 15 1995
--------------------------------------------------------------------------

--------------------------------------------------------------------------
--  Entity declaration for the ram module
--  
--  (file ram.vhd)
--------------------------------------------------------------------------

library IEEE;
USE IEEE.std_logic_1164.ALL;
library DLX;
use DLX.dlx_types.all;

entity ram is

  generic (tpd : Time;                -- input to output delay
 	   tac : Time;                -- access time
 	   mem_size : natural);       -- memory size in words
  port (a_bus : in std_logic_vector(15 downto 2);
	d_bus : inout dlx_word bus;
        enable: in std_logic_vector(0 to 3);
        rw    : in std_logic;
	ready   : out std_logic_vector(0 to 3) );

begin
  assert mem_size <= 16#4000#
    report "Memory size for RAM bank is only defined up to 16384 words"
    severity failure;
    
end ram;





