--------------------------------------------------------------------------
--  DLX PROCESSOR MODEL SUITE
--  Copyright (C) 1995, Martin Gumm
--  University of Stuttgart / Department of Computer Science / IPVR-ISE
--------------------------------------------------------------------------
--  This program is free software; you can redistribute it and/or modify
--  it under the terms of the GNU General Public License as published by
--  the Free Software Foundation; either version 1, or (at your option)
--  any later version.
--
--  This program is distributed in the hope that it will be useful,
--  but WITHOUT ANY WARRANTY; without even the implied warranty of
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--  GNU General Public License for more details.
--------------------------------------------------------------------------
--  Last revision date : November 15 1995
--------------------------------------------------------------------------

--------------------------------------------------------------------------
--  Package to make visible all parts of the DLX_BENCH library
--  
--  (file dlx_b_components.vhd)
--------------------------------------------------------------------------

library IEEE;
USE IEEE.std_logic_1164.ALL;
library DLX;
use DLX.dlx_types.all;

package dlx_b_components is

  COMPONENT clockgen
    PORT (phi1, phi2 : OUT std_logic ;    -- two-phase non-overlapping clocks
      	  reset :      OUT std_logic);    -- synchronous reset
  END COMPONENT;

  COMPONENT decoder
    port (a_bus_hn       : in std_logic_vector(31 downto 28);
          enable         : in dlx_nibble;
	  in_sysram_rdy  : in dlx_nibble;
  	  in_useram_rdy  : in dlx_nibble;
	  ram_ready   : out std_logic;
	  enab_sysram : out dlx_nibble;
	  enab_useram : out dlx_nibble;
	  enab_sysrom : out std_logic;
	  enab_userom : out std_logic;
	  enab_timer  : out std_logic);
  END COMPONENT;

  COMPONENT  timer
    port (a_bus : in std_logic_vector(3 downto 2);  -- select between 3
       	  d_bus  : inout dlx_half bus;              --  32(16) bit registers
          clk    : in std_logic;
          enable : in std_logic;
          rw     : in std_logic;
	  reset  : in std_logic;
          ready  : out std_logic;
	  irq_out: out std_logic_vector(0 to 1) );
  END COMPONENT;

  COMPONENT rom
    port (a_bus  : in  std_logic_vector(15 downto 0);
          d_bus  : out dlx_word bus;
          enable : in  std_logic;
          ready  : out std_logic);
  END COMPONENT;
  	
  COMPONENT ram
    port (a_bus : in std_logic_vector(15 downto 2);
	  d_bus : inout dlx_word bus;
          enable: in std_logic_vector(0 to 3);
          rw    : in std_logic;
	  ready   : out std_logic_vector(0 to 3) );
  END COMPONENT;

    
end dlx_b_components;






