--------------------------------------------------------------------------
--  DLX PROCESSOR MODEL SUITE
--  Copyright (C) 1995, Martin Gumm
--  University of Stuttgart / Department of Computer Science / IPVR-ISE
--------------------------------------------------------------------------
--  This program is free software; you can redistribute it and/or modify
--  it under the terms of the GNU General Public License as published by
--  the Free Software Foundation; either version 1, or (at your option)
--  any later version.
--
--  This program is distributed in the hope that it will be useful,
--  but WITHOUT ANY WARRANTY; without even the implied warranty of
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--  GNU General Public License for more details.
--------------------------------------------------------------------------
--  Last revision date : November 15 1995
--------------------------------------------------------------------------

--------------------------------------------------------------------------
--  entity declaration of the decoder module
--  
--  (file decoder.vhd)
--------------------------------------------------------------------------

-------------------------------------------------------------------------
-- new address space for dlx_bench
--
-- 0000_0000 - 0000_FFFF : system rom (64K)
-- 0001_0000 - 0FFF_FFFF : off-board system rom extension (not instantiated) 
-- 1000_0000 - 1000_FFFF : system ram (64K)
-- 1001_0000 - 6FFF_FFFF : off-board system ram extension (not instantiated)
-- 7000_0000 - 7000_000B : 3 32-bit timer register
-- 7000_000C - 7FFF_FFFF : additional IO address space (not instantiated)
-- 8000_0000 - 8000_FFFF : user rom (64K)
-- 8001_0000 - 8FFF_FFEF : off-board system rom extension (not instantiated)
-- 9000_0000 - 9000_FFFF : system ram (64K)
-- 9001_0000 - FFFF_FFFF : off-board system ram extension (not instantiated)
--------------------------------------------------------------------------

--------------------------------------------------------------------------
-- memory access:
--
--       enable(0:3) | access type
--       -----------------------------------
--          0000     |    memory not enabled
--          1000     |    enable byte access (0. byte)
--          0100     |    enable byte access (1. byte)
--          0010     |    enable byte access (2. byte)
--          0001     |    enable byte access (3. byte)
--          1100     |    enable half word access (16 bit, 0. half word)
--          1100     |    enable half word access (16 bit, 1. half word)
--          1111     |    enable word access (32 bit)
--------------------------------------------------------------------------

library IEEE;
USE IEEE.std_logic_1164.ALL;
library DLX;
use DLX.dlx_types.all;
use STD.textio.all;

entity decoder is
  generic (tpd : Time;	        -- clock to output delay
           MONITOR : boolean);	-- flag for debugging
  port (a_bus_hn       : in std_logic_vector(31 downto 28);
        enable         : in dlx_nibble;
	in_sysram_rdy  : in dlx_nibble;
	in_useram_rdy  : in dlx_nibble;
	ram_ready   : out std_logic;
	enab_sysram : out dlx_nibble;
	enab_useram : out dlx_nibble;	
	enab_sysrom : out std_logic;
	enab_userom : out std_logic;
	enab_timer  : out std_logic);	
end decoder;








