--------------------------------------------------------------------------
--  DLX PROCESSOR MODEL SUITE
--  Copyright (C) 1995, Martin Gumm
--  University of Stuttgart / Department of Computer Science / IPVR-ISE
--------------------------------------------------------------------------
--  This program is free software; you can redistribute it and/or modify
--  it under the terms of the GNU General Public License as published by
--  the Free Software Foundation; either version 1, or (at your option)
--  any later version.
--
--  This program is distributed in the hope that it will be useful,
--  but WITHOUT ANY WARRANTY; without even the implied warranty of
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--  GNU General Public License for more details.
--------------------------------------------------------------------------
--  Last revision date : November 15 1995
--------------------------------------------------------------------------

--------------------------------------------------------------------------
-- Architecture for the test bench for the clock generator
--  
--  (file clockgen_test-bench.vhd)
--------------------------------------------------------------------------

ARCHITECTURE bench OF clockgen_test IS

  COMPONENT clockgen
    PORT (phi1, phi2 : OUT std_logic;
      	  reset      : OUT std_logic);
  END COMPONENT;
  
  SIGNAL p1, p2, reset : std_logic;     -- output signals to examine the
                                        -- generated clockgen output 
  
BEGIN
  --
  -- Instantiation of the clock generator in the test-bench architecture.
  -- No further stimuli signals needeed because the clockgen-architecture
  -- produces output signals without any required input signals
  --
  cg : clockgen
    PORT MAP (p1, p2, reset);
    
END bench;








