--------------------------------------------------------------------------
--  DLX PROCESSOR MODEL SUITE
--  Copyright (C) 1995, Martin Gumm
--  University of Stuttgart / Department of Computer Science / IPVR-ISE
--------------------------------------------------------------------------
--  This program is free software; you can redistribute it and/or modify
--  it under the terms of the GNU General Public License as published by
--  the Free Software Foundation; either version 1, or (at your option)
--  any later version.
--
--  This program is distributed in the hope that it will be useful,
--  but WITHOUT ANY WARRANTY; without even the implied warranty of
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--  GNU General Public License for more details.
--------------------------------------------------------------------------
--  Last revision date : November 15 1995
--------------------------------------------------------------------------

--------------------------------------------------------------------------
--  Entity declaration for the clock generator
--  
--  (file clockgen.vhd)
--------------------------------------------------------------------------

--------------------------------------------------------------------------
-- clock generator signals:
--
--       :_____:   :     :   :_____               _____             _____
-- phi1  /     \_____________/     \_____________/     \___________/     \
--       :     :    _____    :          _____               _____
-- phi2  __________/     \_____________/     \_____________/     \________
--       :_________________________________________________ 
-- reset /     :   :     :   :                             \______________
--       :     :   :     :   :                             ^
--       | tpw |tps| tpw |tps|                             t=5*(tpw+tps) 
--
--------------------------------------------------------------------------

library IEEE;
  USE IEEE.std_logic_1164.all;

ENTITY clockgen IS

  GENERIC (tpw : TIME;		          -- clock pulse width
      	   tps : TIME);		          -- clock pulse separation
     					  
  PORT (phi1, phi2 : OUT std_logic ;    -- two-phase non-overlapping clocks
      	reset :      OUT std_logic);    -- synchronous reset
	
END clockgen;

























