--------------------------------------------------------------------------
--  DLX PROCESSOR MODEL SUITE
--  Copyright (C) 1995, Martin Gumm
--  University of Stuttgart / Department of Computer Science / IPVR-ISE
--------------------------------------------------------------------------
--  This program is free software; you can redistribute it and/or modify
--  it under the terms of the GNU General Public License as published by
--  the Free Software Foundation; either version 1, or (at your option)
--  any later version.
--
--  This program is distributed in the hope that it will be useful,
--  but WITHOUT ANY WARRANTY; without even the implied warranty of
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--  GNU General Public License for more details.
--------------------------------------------------------------------------
--  Last revision date : November 15 1995
--------------------------------------------------------------------------

--------------------------------------------------------------------------
--  *** SYNOPSYS synthesizable code (ver. 3.2.a) ***
--------------------------------------------------------------------------

--------------------------------------------------------------------------
--  Entity declaration for the shifter
--
--  (file word_shifter.vhd)
--------------------------------------------------------------------------

--------------------------------------------------------------------------
-- shift functions:
--
-- lr_switch = 0 -> shift left
--             1 -> shift right
-- ar_switch = 0 -> shift right logical
--             1 -> shift right arithmetical
--------------------------------------------------------------------------

library IEEE;
use IEEE.std_logic_1164.all;

use WORK.dlx_types.all;

entity word_shifter is
  generic (tpd_out : Time);
  port (a : in dlx_word;
      	b : out dlx_word;
	shift : std_logic_vector(4 downto 0);  
        lr_switch : in std_logic;
	ar_switch : in std_logic);
end word_shifter;





