--------------------------------------------------------------------------
--  DLX PROCESSOR MODEL SUITE
--  Copyright (C) 1995, Martin Gumm
--  University of Stuttgart / Department of Computer Science / IPVR-ISE
--------------------------------------------------------------------------
--  This program is free software; you can redistribute it and/or modify
--  it under the terms of the GNU General Public License as published by
--  the Free Software Foundation; either version 1, or (at your option)
--  any later version.
--
--  This program is distributed in the hope that it will be useful,
--  but WITHOUT ANY WARRANTY; without even the implied warranty of
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--  GNU General Public License for more details.
--------------------------------------------------------------------------
--  Last revision date : November 15 1995
--------------------------------------------------------------------------

--------------------------------------------------------------------------
--  *** SYNOPSYS synthesizable code (ver. 3.2.a) ***
--------------------------------------------------------------------------

--------------------------------------------------------------------------
--  Entity declaration for register (32-bit) with one tri-state output
--  and one normal output
--
--  (file reg_1e1.vhd)
--------------------------------------------------------------------------

--------------------------------------------------------------------------
--  latch_en : low active
--  out_en1  : low activ
--------------------------------------------------------------------------

library IEEE;
use IEEE.std_logic_1164.all;

use WORK.dlx_types.all;

entity word_reg_1e1 is
  generic (tpd_latch, tpd_out : Time);
  port (d      : in dlx_word;
	q1, q2 : out dlx_word;
	latch_en : in std_logic;
	out_en1  : in std_logic);
end word_reg_1e1;
