--------------------------------------------------------------------------
--  DLX PROCESSOR MODEL SUITE
--  Copyright (C) 1995, Martin Gumm
--  University of Stuttgart / Department of Computer Science / IPVR-ISE
--------------------------------------------------------------------------
--  This program is free software; you can redistribute it and/or modify
--  it under the terms of the GNU General Public License as published by
--  the Free Software Foundation; either version 1, or (at your option)
--  any later version.
--
--  This program is distributed in the hope that it will be useful,
--  but WITHOUT ANY WARRANTY; without even the implied warranty of
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--  GNU General Public License for more details.
--------------------------------------------------------------------------
--  Last revision date : November 15 1995
--------------------------------------------------------------------------

--------------------------------------------------------------------------
--  *** SYNOPSYS synthesizable code (ver. 3.2.a) ***
--------------------------------------------------------------------------

--------------------------------------------------------------------------
--   Behaviour architecture for register (32-bit)
--   with one tri-state output and one normal output 
--
--  (file reg_1e1-dataflow.vhd)
--------------------------------------------------------------------------

architecture dataflow of word_reg_1e1 is
  signal latch_value : dlx_word;
begin

  lat : process (latch_en, d)
  begin
    if latch_en = '0' then
      latch_value <= To_UX01(d) after tpd_latch;
    end if;
  end process lat;

  q1 <= latch_value after tpd_out when out_en1 = '0' else
        (others => 'Z') after tpd_out;

  q2 <= latch_value;
  
end dataflow;





