--------------------------------------------------------------------------
--  DLX PROCESSOR MODEL SUITE
--  Copyright (C) 1995, Martin Gumm
--  University of Stuttgart / Department of Computer Science / IPVR-ISE
--------------------------------------------------------------------------
--  This program is free software; you can redistribute it and/or modify
--  it under the terms of the GNU General Public License as published by
--  the Free Software Foundation; either version 1, or (at your option)
--  any later version.
--
--  This program is distributed in the hope that it will be useful,
--  but WITHOUT ANY WARRANTY; without even the implied warranty of
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--  GNU General Public License for more details.
--------------------------------------------------------------------------
--  Last revision date : November 15 1995
--------------------------------------------------------------------------

--------------------------------------------------------------------------
--  *** SYNOPSYS synthesizable code (ver. 3.2.a) ***
--------------------------------------------------------------------------

--------------------------------------------------------------------------
--  ripple-carry  architecture of adder (signed add)
--
--  file word_adder-ripple.vhd
--------------------------------------------------------------------------

use WORK.dlx_types.all;

architecture ripple of word_adder is
begin
  
  add_op: process (a, b, c_in)    
    variable result : dlx_word;
    variable intern : std_logic;
    variable carry_out, carry_in : std_logic;
  begin
    carry_in := c_in;
    FOR index IN result'reverse_RANGE LOOP
      intern := a(index) XOR b(index);
      result(index) := intern XOR carry_in;
      carry_out := (a(index) AND b(index)) OR (carry_in AND intern);
      carry_in := carry_out;  			-- of previous bit
    END LOOP;
    ovfl <= carry_out XOR carry_in after tpd_out;
    s <= result after tpd_out;  
  end process add_op;
  
end ripple;
