--------------------------------------------------------------------------
--  DLX PROCESSOR MODEL SUITE
--  Copyright (C) 1995, Martin Gumm
--  University of Stuttgart / Department of Computer Science / IPVR-ISE
--------------------------------------------------------------------------
--  This program is free software; you can redistribute it and/or modify
--  it under the terms of the GNU General Public License as published by
--  the Free Software Foundation; either version 1, or (at your option)
--  any later version.
--
--  This program is distributed in the hope that it will be useful,
--  but WITHOUT ANY WARRANTY; without even the implied warranty of
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--  GNU General Public License for more details.
--------------------------------------------------------------------------
--  Last revision date : November 15 1995
--------------------------------------------------------------------------

--------------------------------------------------------------------------
--  *** SYNOPSYS synthesizable code (ver. 3.2.a) ***
--------------------------------------------------------------------------

--------------------------------------------------------------------------
--  carry-look-ahead architecture of adder (signed add / flat netlist)
--
--  file word_adder-cla_f.vhd
--------------------------------------------------------------------------

architecture cla_f of word_adder is
  signal c : std_logic_vector(31 downto 0);
  signal p : std_logic_vector(31 downto 0);
  signal g : std_logic_vector(31 downto 0);
  signal p_0_1, p_2_3, p_4_5, p_6_7, p_8_9, p_10_11, p_12_13, p_14_15,
         p_16_17, p_18_19, p_20_21, p_22_23, p_24_25, p_26_27, p_28_29,
	 p_30_31 : std_logic;
  signal g_0_1, g_2_3, g_4_5, g_6_7, g_8_9, g_10_11, g_12_13, g_14_15,
         g_16_17, g_18_19, g_20_21, g_22_23, g_24_25, g_26_27, g_28_29,
	 g_30_31 : std_logic;
  signal p_0_3, p_4_7, p_8_11, p_12_15, p_16_19, p_20_23, p_24_27,
         p_28_31 : std_logic;
  signal g_0_3, g_4_7, g_8_11, g_12_15, g_16_19, g_20_23, g_24_27,
         g_28_31 : std_logic;
  signal p_0_7, p_8_15, p_16_23, p_24_31 : std_logic;
  signal g_0_7, g_8_15, g_16_23, g_24_31 : std_logic;
  signal p_0_15, p_16_31 : std_logic;
  signal g_0_15, g_16_31 : std_logic;
  signal c_out_tmp : std_logic;
  
begin
  c(0) <= c_in;
  --
  -- level 0
  --
  s <= a XOR b XOR c;
  p <= a OR b;
  g <= a AND b;
  --
  -- level 1
  --
  c(1) <= g(0) or (p(0) and c(0));
  p_0_1 <= p(0) and p(1);
  g_0_1 <= g(1) or (p(1) and g(0));
  --
  c(3) <= g(2) or (p(2) and c(2));
  p_2_3 <= p(2) and p(3);
  g_2_3 <= g(3) or (p(3) and g(2));
  --
  c(5) <= g(4) or (p(4) and c(4));
  p_4_5 <= p(4) and p(5);
  g_4_5 <= g(5) or (p(5) and g(4));
  --
  c(7) <= g(6) or (p(6) and c(6));
  p_6_7 <= p(6) and p(7);
  g_6_7 <= g(7) or (p(7) and g(6));
  --
  c(9) <= g(8) or (p(8) and c(8));
  p_8_9 <= p(8) and p(9);
  g_8_9 <= g(9) or (p(9) and g(8));
  --
  c(11) <= g(10) or (p(10) and c(10));
  p_10_11 <= p(10) and p(11);
  g_10_11 <= g(11) or (p(11) and g(10));
  --
  c(13) <= g(12) or (p(12) and c(12));
  p_12_13 <= p(12) and p(13);
  g_12_13 <= g(13) or (p(13) and g(12));
  --
  c(15) <= g(14) or (p(14) and c(14));
  p_14_15 <= p(14) and p(15);
  g_14_15 <= g(15) or (p(15) and g(14));
  --
  c(17) <= g(16) or (p(16) and c(16));
  p_16_17 <= p(16) and p(17);
  g_16_17 <= g(17) or (p(17) and g(16));
  --
  c(19) <= g(18) or (p(18) and c(18));
  p_18_19 <= p(18) and p(19);
  g_18_19 <= g(19) or (p(19) and g(18));
  --
  c(21) <= g(20) or (p(20) and c(20));
  p_20_21 <= p(20) and p(21);
  g_20_21 <= g(21) or (p(21) and g(20));
  --
  c(23) <= g(22) or (p(22) and c(22));
  p_22_23 <= p(22) and p(23);
  g_22_23 <= g(23) or (p(23) and g(22));
  --
  c(25) <= g(24) or (p(24) and c(24));
  p_24_25 <= p(24) and p(25);
  g_24_25 <= g(25) or (p(25) and g(24));
  --
  c(27) <= g(26) or (p(26) and c(26));
  p_26_27 <= p(26) and p(27);
  g_26_27 <= g(27) or (p(27) and g(26));
  --
  c(29) <= g(28) or (p(28) and c(28));
  p_28_29 <= p(28) and p(29);
  g_28_29 <= g(29) or (p(29) and g(28));
  --
  c(31) <= g(30) or (p(30) and c(30));
  p_30_31 <= p(30) and p(31);
  g_30_31 <= g(31) or (p(31) and g(30));
  --
  -- level 2
  --
  c(2) <= g_0_1 or (p_0_1 and c(0));
  p_0_3 <= p_0_1 and p_2_3;
  g_0_3 <= g_2_3 or (p_2_3 and g_0_1);
  --
  c(6) <= g_4_5 or (p_4_5 and c(4));
  p_4_7 <= p_4_5 and p_6_7;
  g_4_7 <= g_6_7 or (p_6_7 and g_4_5);
  --
  c(10) <= g_8_9 or (p_8_9 and c(8));
  p_8_11 <= p_8_9 and p_10_11;
  g_8_11 <= g_10_11 or (p_10_11 and g_8_9);
  --
  c(14) <= g_12_13 or (p_12_13 and c(12));
  p_12_15 <= p_12_13 and p_14_15;
  g_12_15 <= g_14_15 or (p_14_15 and g_12_13);
  --
  c(18) <= g_16_17 or (p_16_17 and c(16));
  p_16_19 <= p_16_17 and p_18_19;
  g_16_19 <= g_18_19 or (p_18_19 and g_16_17);
  --
  c(22) <= g_20_21 or (p_20_21 and c(20));
  p_20_23 <= p_20_21 and p_22_23;
  g_20_23 <= g_22_23 or (p_22_23 and g_20_21);
  --
  c(26) <= g_24_25 or (p_24_25 and c(24));
  p_24_27 <= p_24_25 and p_26_27;
  g_24_27 <= g_26_27 or (p_26_27 and g_24_25);
  --
  c(30) <= g_28_29 or (p_28_29 and c(28));
  p_28_31 <= p_28_29 and p_30_31;
  g_28_31 <= g_30_31 or (p_30_31 and g_28_29);
  --
  -- level 3
  --
  c(4) <= g_0_3 or (p_0_3 and c(0));
  p_0_7 <= p_0_3 and p_4_7;
  g_0_7 <= g_4_7 or (p_4_7 and g_0_3);
  --
  c(12) <= g_8_11 or (p_8_11 and c(8));
  p_8_15 <= p_8_11 and p_12_15;
  g_8_15 <= g_12_15 or (p_12_15 and g_8_11);
  --
  c(20) <= g_16_19 or (p_16_19 and c(16));
  p_16_23 <= p_16_19 and p_20_23;
  g_16_23 <= g_20_23 or (p_20_23 and g_16_19);
  --
  c(28) <= g_24_27 or (p_24_27 and c(24));
  p_24_31 <= p_24_27 and p_28_31;
  g_24_31 <= g_28_31 or (p_28_31 and g_24_27);
  --
  -- level 4
  --
  c(8) <= g_0_7 or (p_0_7 and c(0));
  p_0_15 <= p_0_7 and p_8_15;
  g_0_15 <= g_8_15 or (p_8_15 and g_0_7);
  --
  c(24) <= g_16_23 or (p_16_23 and c(16));
  p_16_31 <= p_16_23 and p_24_31;
  g_16_31 <= g_24_31 or (p_24_31 and g_16_23);  
  --
  -- level 5
  --
  c(16) <= g_0_15 or (p_0_15 and c(0));  
  --
  -- overflow
  --
  c_out_tmp <= (a(31) and b(31)) or (a(31) and c(31)) or (b(31) and c(31));
  c_out <= c_out_tmp;
  ovfl <= c_out_tmp XOR c(31);
  
end cla_f;


