--------------------------------------------------------------------------
--  DLX PROCESSOR MODEL SUITE
--  Copyright (C) 1995, Martin Gumm
--  University of Stuttgart / Department of Computer Science / IPVR-ISE
--------------------------------------------------------------------------
--  This program is free software; you can redistribute it and/or modify
--  it under the terms of the GNU General Public License as published by
--  the Free Software Foundation; either version 1, or (at your option)
--  any later version.
--
--  This program is distributed in the hope that it will be useful,
--  but WITHOUT ANY WARRANTY; without even the implied warranty of
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--  GNU General Public License for more details.
--------------------------------------------------------------------------
--  Last revision date : November 15 1995
--------------------------------------------------------------------------

--------------------------------------------------------------------------
--  *** SYNOPSYS synthesizable code (ver. 3.2.a) ***
--------------------------------------------------------------------------
--
--  (file system-structural.vhd)
--------------------------------------------------------------------------

ARCHITECTURE structural OF system IS
  
  COMPONENT dlx
    PORT (a_bus  : out dlx_address;
       	  d_bus  : inout dlx_word bus;
          enable : out dlx_nibble;
	  rw     : out std_logic;
	  error  : out std_logic;
          ready  : in std_logic;
	  reset  : in std_logic;             -- asynchronous reset 
	  halt   : in std_logic;             -- asynchronous halt of processor
	  intrpt : in dlx_nibble;            -- interupt signals (maskable)
          phi1   : in std_logic;             -- 2 phase non overlapping clock
	  phi2   : in std_logic);
  END COMPONENT;

  signal phi1_sig  : std_logic;      -- clock phase 1
  signal phi2_sig  : std_logic;      -- clock phase 2
  signal reset_sig : std_logic;      -- asynchronous reset
  signal halt_sig  : std_logic;      -- processor disable signal

  SIGNAL data_bus   : dlx_word bus;  -- 32 bit data bus
  signal addr_bus   : dlx_address;   -- 32 bit address bus
  signal intrpt_sig : dlx_nibble;    -- four interrupt signals
  signal enable_sig : dlx_nibble;    -- bus transaction enable 
  signal rw_sig     : std_logic;     -- processor rw indicator
  signal ready_sig  : std_logic;     -- data acc./ready
  signal error_sig  : std_logic;     -- error indicator

  signal sysram_rdy_sig : dlx_nibble;      -- four ready signals of the byte organized
                                           -- system ram bank
  signal useram_rdy_sig : dlx_nibble;      -- four ready signals of the byte organized
                                           -- user ram bank
  
  signal en_sysram_sig : dlx_nibble;       -- four enable lines for system ram bank
  signal en_useram_sig : dlx_nibble;       -- four enable lines for user ram bank
  signal en_sysrom_sig : std_logic;        -- enable line for system rom
  signal en_userom_sig : std_logic;        -- enable line for user rom
  signal en_timer_sig  : std_logic;        -- enable line for timer
 
BEGIN

  test_dlx : dlx
    PORT MAP (a_bus  => addr_bus, d_bus => data_bus,
              enable => enable_sig, rw => rw_sig, ready => ready_sig,
	      error => error_sig, reset => reset_sig, halt => halt_sig,
  	      intrpt => intrpt_sig,
	      phi1 => phi1_sig, phi2 => phi2_sig);

  test_sysram : NEW_DLX_BENCH.dlx_b_components.ram
    PORT MAP (a_bus => addr_bus(15 downto 2), d_bus => data_bus,
              enable => en_sysram_sig, rw => rw_sig, ready => sysram_rdy_sig);

  test_useram : NEW_DLX_BENCH.dlx_b_components.ram
    PORT MAP (a_bus => addr_bus(15 downto 2), d_bus => data_bus,
              enable => en_useram_sig, rw => rw_sig, ready => useram_rdy_sig);	      
	      
  test_sysrom : NEW_DLX_BENCH.dlx_b_components.rom
    PORT MAP (a_bus => addr_bus(15 downto 0), d_bus => data_bus,
              enable => en_sysrom_sig, ready => ready_sig);

  test_userom : NEW_DLX_BENCH.dlx_b_components.rom
    PORT MAP (a_bus => addr_bus(15 downto 0), d_bus => data_bus,
              enable => en_userom_sig, ready => ready_sig);

  test_timer : NEW_DLX_BENCH.dlx_b_components.timer
    PORT MAP (a_bus => addr_bus(3 downto 2), d_bus => data_bus(0 to 15),
              enable => en_timer_sig,rw => rw_sig, ready => ready_sig,
              clk => phi1_sig, reset => reset_sig, irq_out => intrpt_sig(0 to 1));

  test_decoder : NEW_DLX_BENCH.dlx_b_components.decoder
    PORT MAP (a_bus_hn => addr_bus(31 downto 28),
              enable => enable_sig,
 	      in_sysram_rdy => sysram_rdy_sig, in_useram_rdy => useram_rdy_sig,
	      ram_ready => ready_sig,
	      enab_sysram => en_sysram_sig, enab_useram => en_useram_sig,
	      enab_sysrom => en_sysrom_sig, enab_userom => en_userom_sig,
 	      enab_timer => en_timer_sig);

  test_clock : NEW_DLX_BENCH.dlx_b_components.clockgen
    PORT MAP (phi1 => phi1_sig, phi2 => phi2_sig, reset => reset_sig);

  intrpt_sig(2 to 3) <= "00";
  halt_sig <= '0';
  
end structural;



