--------------------------------------------------------------------------
--  DLX PROCESSOR MODEL SUITE
--  Copyright (C) 1995, Martin Gumm
--  University of Stuttgart / Department of Computer Science / IPVR-ISE
--------------------------------------------------------------------------
--  This program is free software; you can redistribute it and/or modify
--  it under the terms of the GNU General Public License as published by
--  the Free Software Foundation; either version 1, or (at your option)
--  any later version.
--
--  This program is distributed in the hope that it will be useful,
--  but WITHOUT ANY WARRANTY; without even the implied warranty of
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--  GNU General Public License for more details.
--------------------------------------------------------------------------
--  Last revision date : November 15 1995
--------------------------------------------------------------------------

--------------------------------------------------------------------------
--  *** SYNOPSYS synthesizable code (ver. 3.2.a) ***
--------------------------------------------------------------------------

--------------------------------------------------------------------------
--   Structural architecture for the register file (32 32-bit-reg.)
--   one input, two outputs 
--
--  (file reg_file-structural.vhd)
--------------------------------------------------------------------------

architecture structural of reg_file is

  component word_latch
    port (d : in  dlx_word;
      	  q : out dlx_word;
	  latch_en : std_logic);
  end component;

  component mux_32_1
    port (mux_in   : in dlx_word;
      	  mux_out  : out std_logic;
	  mux_sel  : in std_logic_vector(0 to 4));
  end component;

  component demux_1_32
    port (demux_in   : in  std_logic;
      	  demux_out  : out dlx_word;
	  demux_sel  : in std_logic_vector(0 to 4));
  end component;

  signal latch_out   : dlx_word_array(0 to 31);
  signal demux_wr_en : dlx_word;
  signal mux_in1 : dlx_word_array(0 to 31);
  signal mux_in2 : dlx_word_array(0 to 31);
  
  
begin

  reg_array : for i in 1 to 31 generate
    latch : word_latch
      port map (d => d, q => latch_out(i), latch_en => demux_wr_en(i));
  end generate;      

  out_mux: for i in 0 to 31 generate
    mux1 : mux_32_1
      port map (mux_in => mux_in1(i), mux_out => q1(i), mux_sel => addr_out1);
    mux2 : mux_32_1
      port map (mux_in => mux_in2(i), mux_out => q2(i), mux_sel => addr_out2);
  end generate;

  in_demux : demux_1_32
    port map (demux_in => write_en, demux_out => demux_wr_en, demux_sel => addr_in);

  connect_1: for i in 0 to 31 generate
    connect_2 : for j in 0 to 31 generate
      mux_in1(i)(j) <= latch_out(j)(i);
      mux_in2(i)(j) <= latch_out(j)(i);
    end generate;
  end generate;

  latch_out(0) <= To_stdLogicVector(X"0000_0000");
  
end structural;





