--------------------------------------------------------------------------
--  DLX PROCESSOR MODEL SUITE
--  Copyright (C) 1995, Martin Gumm
--  University of Stuttgart / Department of Computer Science / IPVR-ISE
--------------------------------------------------------------------------
--  This program is free software; you can redistribute it and/or modify
--  it under the terms of the GNU General Public License as published by
--  the Free Software Foundation; either version 1, or (at your option)
--  any later version.
--
--  This program is distributed in the hope that it will be useful,
--  but WITHOUT ANY WARRANTY; without even the implied warranty of
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--  GNU General Public License for more details.
--------------------------------------------------------------------------
--  Last revision date : November 15 1995
--------------------------------------------------------------------------

--------------------------------------------------------------------------
--  *** SYNOPSYS synthesizable code (ver. 3.2.a) ***
--------------------------------------------------------------------------
--------------------------------------------------------------------------
--  Configuration for the register file
--
--  (file reg_file-config_rtl.vhd)
--------------------------------------------------------------------------

configuration reg_file_config_rtl of reg_file is

  for structural

    FOR reg_array(1 to 31)
      FOR latch : word_latch
        USE ENTITY WORK.word_latch(dataflow)
	  GENERIC MAP (tpd_latch => 2 ns);
      end for; -- latch
    end for; -- reg_array

    FOR out_mux(0 to 31)
      for mux1 : mux_32_1
        USE ENTITY WORK.mux_32_1(behaviour)
	  GENERIC MAP (tpd_mux => 2 ns);
      end for; -- mux1	  
      for mux2 : mux_32_1
        USE ENTITY WORK.mux_32_1(behaviour)
	  GENERIC MAP (tpd_mux => 2 ns);
      end for; -- mux2
    end for; -- out_mux
    
    FOR in_demux : demux_1_32
      USE ENTITY WORK.demux_1_32(behaviour)
	GENERIC MAP (tpd_demux => 2 ns);
    end for; -- demux
      
  end for; -- structural

end reg_file_config_rtl;


