--------------------------------------------------------------------------
--  DLX PROCESSOR MODEL SUITE
--  Copyright (C) 1995, Martin Gumm
--  University of Stuttgart / Department of Computer Science / IPVR-ISE
--------------------------------------------------------------------------
--  This program is free software; you can redistribute it and/or modify
--  it under the terms of the GNU General Public License as published by
--  the Free Software Foundation; either version 1, or (at your option)
--  any later version.
--
--  This program is distributed in the hope that it will be useful,
--  but WITHOUT ANY WARRANTY; without even the implied warranty of
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--  GNU General Public License for more details.
--------------------------------------------------------------------------
--  Last revision date : November 15 1995
--------------------------------------------------------------------------

--------------------------------------------------------------------------
--  *** SYNOPSYS synthesizable code (ver. 3.2.a) ***
--------------------------------------------------------------------------

--------------------------------------------------------------------------
--   Behaviour architecture for the register file (8 32-bit-reg.)
--   one input, two outputs 
--
--  (file reg_file-behaviour_3.vhd)
--------------------------------------------------------------------------

architecture behaviour_3 of reg_file is
  signal register_file : dlx_word_array(1 to 31);
begin

  --
  -- do write if enabled
  --
  latch: process (d, write_en, addr_in)
  begin
    if write_en = '0' then
      case addr_in is
	when "00001" => register_file(1) <= d after tpd_in;
	when "00010" => register_file(2) <= d after tpd_in;
	when "00011" => register_file(3) <= d after tpd_in;
	when "00100" => register_file(4) <= d after tpd_in;
	when "00101" => register_file(5) <= d after tpd_in;
	when "00110" => register_file(6) <= d after tpd_in;
	when "00111" => register_file(7) <= d after tpd_in;
	--synopsys synthesis_off
        --(outcommenting because of SYNOPSYS crash bug !)
        --
	--when "01000" => register_file(8) <= d after tpd_in;
	--when "01001" => register_file(9) <= d after tpd_in;
	--when "01010" => register_file(10) <= d after tpd_in;
	--when "01011" => register_file(11) <= d after tpd_in;
	--when "01100" => register_file(12) <= d after tpd_in;
	--when "01101" => register_file(13) <= d after tpd_in;
	--when "01110" => register_file(14) <= d after tpd_in;
	--when "01111" => register_file(15) <= d after tpd_in;
	--when "10000" => register_file(16) <= d after tpd_in;
	--when "10001" => register_file(17) <= d after tpd_in;
	--when "10010" => register_file(18) <= d after tpd_in;
	--when "10011" => register_file(19) <= d after tpd_in;
	--when "10100" => register_file(20) <= d after tpd_in;
	--when "10101" => register_file(21) <= d after tpd_in;	  
	--when "10110" => register_file(22) <= d after tpd_in;
	--when "10111" => register_file(23) <= d after tpd_in;
	--when "11000" => register_file(24) <= d after tpd_in;
	--when "11001" => register_file(25) <= d after tpd_in;
	--when "11010" => register_file(26) <= d after tpd_in;
	--when "11011" => register_file(27) <= d after tpd_in;
	--when "11100" => register_file(28) <= d after tpd_in;
	--when "11101" => register_file(29) <= d after tpd_in;
	--when "11110" => register_file(30) <= d after tpd_in;
	--synopsys synthesis_on
	when "11111" => register_file(31) <= d after tpd_in;
	when others  => null; 
      end case;
    end if;      
  end process latch;
  
  --
  -- read port 1
  --
  out1: process (addr_out1, register_file)
  begin
    case addr_out1 is
      when "00001" => q1 <= register_file(1) after tac;
      when "00010" => q1 <= register_file(2) after tac;
      when "00011" => q1 <= register_file(3) after tac;
      when "00100" => q1 <= register_file(4) after tac;
      when "00101" => q1 <= register_file(5) after tac;
      when "00110" => q1 <= register_file(6) after tac;
      when "00111" => q1 <= register_file(7) after tac;
      --synopsys synthesis_off
      --(outcommenting because of SYNOPSYS crash bug !)
      --
      --when "01000" => q1 <= register_file(8) after tac;
      --when "01001" => q1 <= register_file(9) after tac;
      --when "01010" => q1 <= register_file(10) after tac;
      --when "01011" => q1 <= register_file(11) after tac;
      --when "01100" => q1 <= register_file(12) after tac;
      --when "01101" => q1 <= register_file(13) after tac;
      --when "01110" => q1 <= register_file(14) after tac;
      --when "01111" => q1 <= register_file(15) after tac;
      --when "10000" => q1 <= register_file(16) after tac;
      --when "10001" => q1 <= register_file(17) after tac;
      --when "10010" => q1 <= register_file(18) after tac;
      --when "10011" => q1 <= register_file(19) after tac;
      --when "10100" => q1 <= register_file(20) after tac;
      --when "10101" => q1 <= register_file(21) after tac;        
      --when "10110" => q1 <= register_file(22) after tac;
      --when "10111" => q1 <= register_file(23) after tac;
      --when "11000" => q1 <= register_file(24) after tac;
      --when "11001" => q1 <= register_file(25) after tac;
      --when "11010" => q1 <= register_file(26) after tac;
      --when "11011" => q1 <= register_file(27) after tac;
      --when "11100" => q1 <= register_file(28) after tac;
      --when "11101" => q1 <= register_file(29) after tac;
      --when "11110" => q1 <= register_file(30) after tac;
      --synopsys synthesis_on
      when "11111" => q1 <= register_file(31) after tac;
      when others  => q1 <= To_StdLogicVector(X"0000_0000") after tac; 
    end case;
  end process out1;
     
  --
  -- read port 2
  --
  out2: process (addr_out2, register_file)
  begin
    case addr_out2 is
      when "00001" => q2 <= register_file(1) after tac;
      when "00010" => q2 <= register_file(2) after tac;
      when "00011" => q2 <= register_file(3) after tac;
      when "00100" => q2 <= register_file(4) after tac;
      when "00101" => q2 <= register_file(5) after tac;
      when "00110" => q2 <= register_file(6) after tac;
      when "00111" => q2 <= register_file(7) after tac;
      --synopsys synthesis_off
      --(outcommenting because of SYNOPSYS crash bug !)
      --
      --when "01000" => q2 <= register_file(8) after tac;
      --when "01001" => q2 <= register_file(9) after tac;
      --when "01010" => q2 <= register_file(10) after tac;
      --when "01011" => q2 <= register_file(11) after tac;
      --when "01100" => q2 <= register_file(12) after tac;
      --when "01101" => q2 <= register_file(13) after tac;
      --when "01110" => q2 <= register_file(14) after tac;
      --when "01111" => q2 <= register_file(15) after tac;
      --when "10000" => q2 <= register_file(16) after tac;
      --when "10001" => q2 <= register_file(17) after tac;
      --when "10010" => q2 <= register_file(18) after tac;
      --when "10011" => q2 <= register_file(19) after tac;
      --when "10100" => q2 <= register_file(20) after tac;
      --when "10101" => q2 <= register_file(21) after tac;        
      --when "10110" => q2 <= register_file(22) after tac;
      --when "10111" => q2 <= register_file(23) after tac;
      --when "11000" => q2 <= register_file(24) after tac;
      --when "11001" => q2 <= register_file(25) after tac;
      --when "11010" => q2 <= register_file(26) after tac;
      --when "11011" => q2 <= register_file(27) after tac;
      --when "11100" => q2 <= register_file(28) after tac;
      --when "11101" => q2 <= register_file(29) after tac;
      --when "11110" => q2 <= register_file(30) after tac;
      --synopsys synthesis_on
      when "11111" => q2 <= register_file(31) after tac;
      when others  => q2 <= To_StdLogicVector(X"0000_0000") after tac; 
    end case;
  end process out2;

end behaviour_3;
