--------------------------------------------------------------------------
--  DLX PROCESSOR MODEL SUITE
--  Copyright (C) 1995, Martin Gumm
--  University of Stuttgart / Department of Computer Science / IPVR-ISE
--------------------------------------------------------------------------
--  This program is free software; you can redistribute it and/or modify
--  it under the terms of the GNU General Public License as published by
--  the Free Software Foundation; either version 1, or (at your option)
--  any later version.
--
--  This program is distributed in the hope that it will be useful,
--  but WITHOUT ANY WARRANTY; without even the implied warranty of
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--  GNU General Public License for more details.
--------------------------------------------------------------------------
--  Last revision date : November 15 1995
--------------------------------------------------------------------------

--------------------------------------------------------------------------
--  *** SYNOPSYS synthesizable code (ver. 3.2.a) ***
--------------------------------------------------------------------------

--------------------------------------------------------------------------
--   Behaviour architecture for the register file (32 32-bit-reg.)
--   one input, two outputs 
--
--  (file reg_file-behaviour_2.vhd)
--------------------------------------------------------------------------

library IEEE_EXTD;
use IEEE_EXTD.stdl1164_vector_arithmetic.sv_to_natural;

architecture behaviour_2 of reg_file is
  signal register_file : dlx_word_array(1 to 31);
begin

  --
  -- do write first if enabled
  --
  latch: process (d, write_en, addr_in)
    variable index : reg_index;
  begin
    if write_en = '0' then
      index := sv_to_natural(addr_in);
      if index /= 0 then
      	register_file(index) <= d after tpd_in;
      end if;
    end if;
  end process latch;
  
  --
  -- read port 1
  --
  out1: process (addr_out1, register_file)
    variable index : reg_index;
  begin
    index := sv_to_natural(addr_out1);
    if index /= 0 then
      q1 <= register_file(index) after tac;
    else
      q1 <= To_StdLogicVector(X"0000_0000") after tac;
    end if;
  end process out1;
  
  --
  -- read port 2
  --
  out2: process (addr_out2, register_file)
    variable index : reg_index;
  begin
    index := sv_to_natural(addr_out2);
    if index /= 0 then
      q2 <= register_file(index) after tac;
    else
      q2 <= To_StdLogicVector(X"0000_0000") after tac;
    end if;
  end process out2;

end behaviour_2;






