--------------------------------------------------------------------------
--  DLX PROCESSOR MODEL SUITE
--  Copyright (C) 1995, Martin Gumm
--  University of Stuttgart / Department of Computer Science / IPVR-ISE
--------------------------------------------------------------------------
--  This program is free software; you can redistribute it and/or modify
--  it under the terms of the GNU General Public License as published by
--  the Free Software Foundation; either version 1, or (at your option)
--  any later version.
--
--  This program is distributed in the hope that it will be useful,
--  but WITHOUT ANY WARRANTY; without even the implied warranty of
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--  GNU General Public License for more details.
--------------------------------------------------------------------------
--  Last revision date : November 15 1995
--------------------------------------------------------------------------

--------------------------------------------------------------------------
--  *** SYNOPSYS synthesizable code (ver. 3.2.a) ***
--------------------------------------------------------------------------

--------------------------------------------------------------------------
--   Behaviour architecture for the register file (32 32-bit-reg.)
--   one input, two outputs 
--
--  (file reg_file-behaviour_1.vhd)
--------------------------------------------------------------------------

library IEEE_EXTD;
use IEEE_EXTD.stdl1164_vector_arithmetic.sv_to_natural;
  
architecture behaviour_1 of reg_file is
  
begin

  reg: process (addr_out1, addr_out2, addr_in, d, write_en)

    variable register_file : dlx_word_array(1 to 31);
    variable reg_index1, reg_index2, reg_index3 : reg_index;

  begin
    --
    -- do write first if enabled
    --
    if write_en = '0' then
      reg_index3 := sv_to_natural(addr_in);
      if reg_index3 /= 0 then
      	register_file(reg_index3) := d;
      end if;
    end if;
    --
    -- read port 1
    --
    reg_index1 := sv_to_natural(addr_out1);
    if reg_index1 /= 0 then
      q1 <= register_file(reg_index1) after tac;
    else
      q1 <= To_StdLogicVector(X"0000_0000") after tac;
    end if;
    --
    -- read port 2
    --
    reg_index2 := sv_to_natural(addr_out2);
    if reg_index2 /= 0 then
      q2 <= register_file(reg_index2) after tac;
    else
      q2 <= To_StdLogicVector(X"0000_0000") after tac;
    end if;
  end process reg;

end behaviour_1;

