--------------------------------------------------------------------------
--  DLX PROCESSOR MODEL SUITE
--  Copyright (C) 1995, Martin Gumm
--  University of Stuttgart / Department of Computer Science / IPVR-ISE
--------------------------------------------------------------------------
--  This program is free software; you can redistribute it and/or modify
--  it under the terms of the GNU General Public License as published by
--  the Free Software Foundation; either version 1, or (at your option)
--  any later version.
--
--  This program is distributed in the hope that it will be useful,
--  but WITHOUT ANY WARRANTY; without even the implied warranty of
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--  GNU General Public License for more details.
--------------------------------------------------------------------------
--  Last revision date : November 15 1995
--------------------------------------------------------------------------

--------------------------------------------------------------------------
--  *** SYNOPSYS synthesizable code (ver. 3.2.a) ***
--------------------------------------------------------------------------

--------------------------------------------------------------------------
--   behaviour architecture for memory data register (32-bit)
--   with one tri-state output and one normal output 
--  (register with special shift capabilities)
--
--  (file mdr-behaviour.vhd)
--------------------------------------------------------------------------

architecture behaviour of mdr is
  signal latch_value : dlx_word;
  signal tmp_value : dlx_word;
  signal op_vec : std_logic_vector(0 to 4);
  constant dc_16 : dlx_half := "----------------";
  constant dc_8 : dlx_byte := "--------";
begin
  op_vec <= shift_ctrl & mar_ls2_in;

  latch : process (latch_en, tmp_value)
  begin
    if latch_en = '0' then
      latch_value <= To_UX01(tmp_value) after tpd_latch;
    end if;
  end process latch;
  
  logic : process (d, op_vec)
  begin
    case op_vec is
      when "10010" |                          -- load ls-half
           "10110" =>                         -- load byte 2
        -- load lower half into upper half
        -- (load byte 2 into byte 0)
        tmp_value <= To_UX01(d(16 to 31)) & dc_16 after tpd_logic;
      when "10101" =>                         -- load byte 1
	-- load byte 1 into byte 0
	tmp_value <= To_UX01(d(8 to 15)) & dc_8 & dc_16 after tpd_logic;
      when "10111" =>                         -- load byte 3
	-- load byte 1 into byte 0
	tmp_value <= To_UX01(d(24 to 31)) & dc_8 & dc_16 after tpd_logic;
      when "11000" |                          -- store ms-half
	   "11101" =>                         -- store byte 1
	-- load lower half into upper half
	-- (load byte 3 into byte 1)
        tmp_value <= To_UX01(d(16 to 31)) & dc_16 after tpd_logic;
      when "11100" =>                         -- store byte 0
	-- load byte 3 into byte 0
	tmp_value <= To_UX01(d(24 to 31)) & dc_8 & dc_16 after tpd_logic;
      when "11110" =>                         -- store byte 2
	-- load byte 3 into byte 2
	tmp_value <= dc_16 & To_UX01(d(24 to 31)) & dc_8 after tpd_logic;
      when others =>                         -- load word / load ms half / load byte 0
	                                       -- store word / store ls half / store byte 3
        -- load unchanged from input
        tmp_value <= To_UX01(d) after tpd_logic;
    end case;
  end process logic;

  q1 <= latch_value after tpd_out when out_en1 = '0' else
        (others => 'Z') after tpd_out;

  q2 <= latch_value;
  
end behaviour;





