--------------------------------------------------------------------------
--  DLX PROCESSOR MODEL SUITE
--  Copyright (C) 1995, Martin Gumm
--  University of Stuttgart / Department of Computer Science / IPVR-ISE
--------------------------------------------------------------------------
--  This program is free software; you can redistribute it and/or modify
--  it under the terms of the GNU General Public License as published by
--  the Free Software Foundation; either version 1, or (at your option)
--  any later version.
--
--  This program is distributed in the hope that it will be useful,
--  but WITHOUT ANY WARRANTY; without even the implied warranty of
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--  GNU General Public License for more details.
--------------------------------------------------------------------------
--  Last revision date : November 15 1995
--------------------------------------------------------------------------

--------------------------------------------------------------------------
--  *** SYNOPSYS synthesizable code (ver. 3.2.a) ***
--------------------------------------------------------------------------

--------------------------------------------------------------------------
--  Behavioural architecture for the instruction decoder 3
--
--  file ir_decode_3-behaviour.vhd
--------------------------------------------------------------------------

architecture behaviour of ir_decode_3 is

begin
  decode_3 : process(instr_in)
  begin
    case instr_in(0 to 5) is
      when op_rr_alu =>
        case instr_in(26 to 31) is
          when rr_func_add | rr_func_sub | rr_func_and | rr_func_or | rr_func_xor |
	       rr_func_seq | rr_func_sne | rr_func_slt | rr_func_sle |
	       rr_func_sgt | rr_func_sge | rr_func_lw | rr_func_lh | rr_func_lb |
 	       rr_func_sw | rr_func_sh | rr_func_sb =>
	    s1_sel <= '0' after tpd_dec;          -- s1_enab normal for icr, iar, tbr               
	    rd_s2_adr_sel <= '1' after tpd_dec;   -- rd = rd(Rtype) / rs2 = rs2(Rtype) 
	    rd_adr_set31 <= '0' after tpd_dec;    -- rd /= link reg
	    priv_ins_out <= '0' after tpd_dec;    -- no priviledged instruction
	  when rr_func_movs2i | rr_func_movi2s =>
	    s1_sel <= '1' after tpd_dec;          -- s1_enab = f(rd) for icr, iar, tbr 
	    rd_s2_adr_sel <= '1' after tpd_dec;   -- rd = rd(Rtype) / rs2 = rs2(Rtype) 
	    rd_adr_set31 <= '0' after tpd_dec;    -- rd /= link reg
	    priv_ins_out <= '1' after tpd_dec;    -- priviledged instruction
	  when others =>
	    s1_sel <= '0' after tpd_dec;          -- s1_enab normal for icr, iar, tbr               
	    rd_s2_adr_sel <= '0' after tpd_dec;   -- rd = rd(Rtype) / rs2 = rs2(Itype)
	    rd_adr_set31 <= '0' after tpd_dec;    -- rd /= link reg
	    priv_ins_out <= '0' after tpd_dec;    -- no priviledged instruction
        end case;
      when op_jal | op_jalr =>
	s1_sel <= '0' after tpd_dec;              -- s1_enab normal for icr, iar, tbr 
        rd_s2_adr_sel <= '0' after tpd_dec;       -- (rd = rd(Rtype) / rs2 = rs2(Itype))
        rd_adr_set31 <= '1' after tpd_dec;        -- rd = link reg 
	priv_ins_out <= '0' after tpd_dec;        -- no priviledged instruction
      when op_rfe =>
	s1_sel <= '0' after tpd_dec;              -- s1_enab normal for icr, iar, tbr               
	rd_s2_adr_sel <= '0' after tpd_dec;       -- rd = rd(Rtype) / rs2 = rs2(Itype)
	rd_adr_set31 <= '0' after tpd_dec;        -- rd /= link reg
	priv_ins_out <= '1' after tpd_dec;        --  priviledged instruction
      when others =>
	s1_sel <= '0' after tpd_dec;              -- s1_enab normal for icr, iar, tbr               
	rd_s2_adr_sel <= '0' after tpd_dec;       -- rd = rd(Rtype) / rs2 = rs2(Itype)
	rd_adr_set31 <= '0' after tpd_dec;        -- rd /= link reg
	priv_ins_out <= '0' after tpd_dec;        -- no priviledged instruction
    end case;
  end process decode_3;

end behaviour;


