--------------------------------------------------------------------------
--  DLX PROCESSOR MODEL SUITE
--  Copyright (C) 1995, Martin Gumm
--  University of Stuttgart / Department of Computer Science / IPVR-ISE
--------------------------------------------------------------------------
--  This program is free software; you can redistribute it and/or modify
--  it under the terms of the GNU General Public License as published by
--  the Free Software Foundation; either version 1, or (at your option)
--  any later version.
--
--  This program is distributed in the hope that it will be useful,
--  but WITHOUT ANY WARRANTY; without even the implied warranty of
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--  GNU General Public License for more details.
--------------------------------------------------------------------------
--  Last revision date : November 15 1995
--------------------------------------------------------------------------

--------------------------------------------------------------------------
--  *** SYNOPSYS synthesizable code (ver. 3.2.a) ***
--------------------------------------------------------------------------

--------------------------------------------------------------------------
--  Behavioural architecture for the instruction decoder 1
--
--  file ir_decode_1-behaviour.vhd
--------------------------------------------------------------------------

architecture behaviour of ir_decode_1 is

begin
  decode_1 : process(instr_in)
  begin
    case instr_in(0 to 5) is
    --
      when op_rr_alu =>
	case instr_in(26 to 31) is
	  --
	  when rr_func_nop =>
	    dec1_out <= fetch after tpd_dec;
	  --
	  when rr_func_add =>
	    dec1_out <= add_1 after tpd_dec;
	  --
	  when rr_func_sub =>
	    dec1_out <= sub_1 after tpd_dec;
	  --
	  when rr_func_and =>
	    dec1_out <= and_1 after tpd_dec;
	  --
	  when rr_func_or =>
	    dec1_out <= or_1 after tpd_dec;
	  --
	  when rr_func_xor =>
	    dec1_out <= xor_1 after tpd_dec;
	  --
	  when rr_func_sll =>
	    dec1_out <= sll_1 after tpd_dec;
	  --
	  when rr_func_srl =>
	    dec1_out <= srl_1 after tpd_dec;
	  --
	  when rr_func_sra =>
	    dec1_out <= sra_1 after tpd_dec;
	  --
	  when rr_func_seq =>
	    dec1_out <= seq_1 after tpd_dec;
	  --
	  when rr_func_sne =>
	    dec1_out <= sne_1 after tpd_dec;
	  --
	  when rr_func_sgt =>
	    dec1_out <= sgt_1 after tpd_dec;
	  --
	  when rr_func_sge =>
	    dec1_out <= sge_1 after tpd_dec;
	  --
	  when rr_func_slt =>
	    dec1_out <= slt_1 after tpd_dec;
	  --
	  when rr_func_sle =>
	    dec1_out <= sle_1 after tpd_dec;
	  --
	  when rr_func_movi2s =>
            dec1_out <= movi2s after tpd_dec;
	  --
	  when rr_func_movs2i =>
            dec1_out <= movs2i after tpd_dec;
	  --
          when  rr_func_lw | rr_func_lh | rr_func_lb |
 	        rr_func_sw | rr_func_sh | rr_func_sb =>
	    dec1_out <= memory after tpd_dec;
          --
	  when others =>
	    dec1_out <= ill_rraf after tpd_dec;
	end case;
      --
      when op_lw_i | op_lh_i | op_lb_i | op_sw_i | op_sh_i | op_sb_i =>
	dec1_out <= memory after tpd_dec;
      --
      when op_lhi =>        
	dec1_out <= lhi after tpd_dec;
      when op_add_i =>        
	dec1_out <= add_1 after tpd_dec;
      when op_sub_i =>        
	dec1_out <= sub_1 after tpd_dec;
      when op_and_i =>        
	dec1_out <= and_1 after tpd_dec;
      when op_or_i =>        
	dec1_out <= or_1 after tpd_dec;
      when op_xor_i =>        
	dec1_out <= xor_1 after tpd_dec;
      when op_sll_i =>        
	dec1_out <= sll_1 after tpd_dec;
      when op_srl_i =>        
	dec1_out <= srl_1 after tpd_dec;
      when op_sra_i =>
	dec1_out <= sra_1 after tpd_dec;
      when op_seq_i =>
	dec1_out <= seq_1 after tpd_dec;	
      when op_sne_i =>
	dec1_out <= sne_1 after tpd_dec;	
      when op_sgt_i =>
	dec1_out <= sgt_1 after tpd_dec;	
      when op_sge_i =>
	dec1_out <= sge_1 after tpd_dec;	
      when op_slt_i =>
	dec1_out <= slt_1 after tpd_dec;	
      when op_sle_i =>
	dec1_out <= sle_1 after tpd_dec;
      --
      when op_beqz =>
	dec1_out <= br_eqz after tpd_dec;
      --
      when op_bnez =>
	dec1_out <= br_nez after tpd_dec;
      --
      when op_j =>
	dec1_out <= jump after tpd_dec;
      --
      when op_jal =>
	dec1_out <= jump_lnk_1 after tpd_dec;
      --
      when op_jr =>
	dec1_out <= jump_reg after tpd_dec;
      --
      when op_jalr =>
	dec1_out <= jump_lnk_reg_1 after tpd_dec;
      --
      when op_trap =>
	dec1_out <= trap_1 after tpd_dec;
      --
      when op_rfe =>
	dec1_out <= rfe_1 after tpd_dec;
      --
      when others =>
	dec1_out <= ill_opc after tpd_dec;
    end case;
  end process decode_1;    

end behaviour;


