--------------------------------------------------------------------------
--  DLX PROCESSOR MODEL SUITE
--  Copyright (C) 1995, Martin Gumm
--  University of Stuttgart / Department of Computer Science / IPVR-ISE
--------------------------------------------------------------------------
--  This program is free software; you can redistribute it and/or modify
--  it under the terms of the GNU General Public License as published by
--  the Free Software Foundation; either version 1, or (at your option)
--  any later version.
--
--  This program is distributed in the hope that it will be useful,
--  but WITHOUT ANY WARRANTY; without even the implied warranty of
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--  GNU General Public License for more details.
--------------------------------------------------------------------------
--  Last revision date : November 15 1995
--------------------------------------------------------------------------

--------------------------------------------------------------------------
--  *** SYNOPSYS synthesizable code (ver. 3.2.a) ***
--------------------------------------------------------------------------

--------------------------------------------------------------------------
--  Entity declaration for instruction register
--
--  (file ir.vhd)
--------------------------------------------------------------------------

--------------------------------------------------------------------------
--  latch_en    : low active
--  immed_o1_en : low activ
--  immed_o2_en : low activ
--  immed_size  : '0'-> 16 bit   / '1'-> 26 bit
--  immed_sign  : '0'-> unsigned / '1' signed
--------------------------------------------------------------------------

use WORK.dlx_types.all;
library IEEE;
use IEEE.std_logic_1164.all;
library IEEE_EXTD;
use IEEE_EXTD.stdl1164_vector_arithmetic.sv_zext,
    IEEE_EXTD.stdl1164_vector_arithmetic.sv_sext;
--synopsys synthesis_off
use WORK.dlx_instructions.write_instr;
use STD.textio.all;
--synopsys synthesis_on

entity ir is
  generic (tpd_latch, tpd_out : Time;
           DEBUG : boolean := false);
  port (d        : in dlx_word;
	latch_en : in std_logic;
	ir_out   : out dlx_word;
	immed_o1_en : in std_logic;
 	immed_out1  : out dlx_word;
	immed_o2_en : in std_logic;
 	immed_out2  : out dlx_word;
 	immed_size  : in std_logic;                 
 	immed_sign  : in std_logic);              
end ir;
