--------------------------------------------------------------------------
--  DLX PROCESSOR MODEL SUITE
--  Copyright (C) 1995, Martin Gumm
--  University of Stuttgart / Department of Computer Science / IPVR-ISE
--------------------------------------------------------------------------
--  This program is free software; you can redistribute it and/or modify
--  it under the terms of the GNU General Public License as published by
--  the Free Software Foundation; either version 1, or (at your option)
--  any later version.
--
--  This program is distributed in the hope that it will be useful,
--  but WITHOUT ANY WARRANTY; without even the implied warranty of
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--  GNU General Public License for more details.
--------------------------------------------------------------------------
--  Last revision date : November 15 1995
--------------------------------------------------------------------------

--------------------------------------------------------------------------
--  *** SYNOPSYS synthesizable code (ver. 3.2.a) ***
--------------------------------------------------------------------------

--------------------------------------------------------------------------
--  Behavioural architecture of instruction register
--
--  file ir-behaviour.vhd
--------------------------------------------------------------------------

architecture behaviour of ir is
  signal instruction : dlx_word;
begin

  latch: process (d, latch_en)
     --synopsys synthesis_off
     variable L : Line;
     --synopsys synthesis_on
  begin
    if latch_en = '0' then
      --synopsys synthesis_off
      if DEBUG then
        write(L, string'("instruction in IR: "));
	write_instr(L, d);
	writeline(output, L);
      end if;
      --synopsys synthesis_on
      instruction <= To_UX01(d) after tpd_latch;
    end if;
  end process latch;

  ir_output: process (instruction, immed_o1_en, immed_o2_en, immed_size, immed_sign)
  begin  
    if immed_o1_en = '0' then
      if immed_size = '0' then
	if immed_sign = '0' then
	  immed_out1 <= sv_zext(instruction(16 to 31), 32) after tpd_out;
	else
	  immed_out1 <= sv_sext(instruction(16 to 31), 32) after tpd_out;
	end if;
      else
	if immed_sign = '0' then
	  immed_out1 <= sv_zext(instruction(6 to 31), 32) after tpd_out;
	else
	  immed_out1 <= sv_sext(instruction(6 to 31), 32) after tpd_out;
	end if;
      end if;
    else
      immed_out1 <= (others => 'Z') after tpd_out;
    end if;

    if immed_o2_en = '0' then
      if immed_size = '0' then
	if immed_sign = '0' then
	  immed_out2 <= sv_zext(instruction(16 to 31), 32) after tpd_out;
	else
	  immed_out2 <= sv_sext(instruction(16 to 31), 32) after tpd_out;
	end if;
      else
	if immed_sign = '0' then
	  immed_out2 <= sv_zext(instruction(6 to 31), 32) after tpd_out;
	else
	  immed_out2 <= sv_sext(instruction(6 to 31), 32) after tpd_out;
	end if;
      end if;
    else
      immed_out2 <= (others => 'Z') after tpd_out;
    end if;
  end process ir_output;
  
  ir_out <= instruction;
    
end behaviour;
