--------------------------------------------------------------------------
--  DLX PROCESSOR MODEL SUITE
--  Copyright (C) 1995, Martin Gumm
--  University of Stuttgart / Department of Computer Science / IPVR-ISE
--------------------------------------------------------------------------
--  This program is free software; you can redistribute it and/or modify
--  it under the terms of the GNU General Public License as published by
--  the Free Software Foundation; either version 1, or (at your option)
--  any later version.
--
--  This program is distributed in the hope that it will be useful,
--  but WITHOUT ANY WARRANTY; without even the implied warranty of
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--  GNU General Public License for more details.
--------------------------------------------------------------------------
--  Last revision date : November 15 1995
--------------------------------------------------------------------------

--------------------------------------------------------------------------
--  *** SYNOPSYS synthesizable code (ver. 3.2.a) ***
--------------------------------------------------------------------------

--------------------------------------------------------------------------
--   Entity declaration for ICR register (32-bit)
--   with one tri-state output ond
--   additional bit load function for ICR(26 to 31)
--
--  (file icr.vhd)
--------------------------------------------------------------------------

--------------------------------------------------------------------------
--  latch_en  : low active
--  out_en    : low active
--  xx_set, xx_en : low active
--------------------------------------------------------------------------

library IEEE;
use IEEE.std_logic_1164.all;
use WORK.dlx_types.all;

entity icr is
  generic (tpd_latch, tpd_out : Time);                 
  port (d  : in dlx_word;                -- data in from dest_bus
        latch_en : in std_logic;         -- enable load from dest_bus
        q       : out dlx_word;          -- output to s_bus 
	out_en  : in std_logic;          -- enable output to s_bus
	--
        s_en    : in std_logic;          -- set s bit
	ioc_en  : in std_logic;          -- set ioc bit
	irra_en : in std_logic;          -- set irra bit
	iav_en  : in std_logic;          -- set iav bit
	dav_en  : in std_logic;          -- set dav bit
	ovad_en : in std_logic;          -- set ovad bit
	ovar_en : in std_logic;          -- set ovar bit
	priv_en : in std_logic;          -- set priv bit
	super   : out std_logic;         -- supervisor bit
	--
	intrpt_in : in dlx_nibble;       -- input from intrpt. port
	intrpt_en : in std_logic;        -- enable load from intrpt. port   
	intrpt    : out std_logic);      -- at least one masked interrupt active
end icr;







