--------------------------------------------------------------------------
--  DLX PROCESSOR MODEL SUITE
--  Copyright (C) 1995, Martin Gumm
--  University of Stuttgart / Department of Computer Science / IPVR-ISE
--------------------------------------------------------------------------
--  This program is free software; you can redistribute it and/or modify
--  it under the terms of the GNU General Public License as published by
--  the Free Software Foundation; either version 1, or (at your option)
--  any later version.
--
--  This program is distributed in the hope that it will be useful,
--  but WITHOUT ANY WARRANTY; without even the implied warranty of
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--  GNU General Public License for more details.
--------------------------------------------------------------------------
--  Last revision date : November 15 1995
--------------------------------------------------------------------------

--------------------------------------------------------------------------
--  *** SYNOPSYS synthesizable code (ver. 3.2.a) ***
--------------------------------------------------------------------------

--------------------------------------------------------------------------
--  Dataflow descrition of the 1-to-32 demux (low active)
--  
--  (file mux_1_32-behaviour.vhd)
--------------------------------------------------------------------------

architecture behaviour of demux_1_32 is

begin 
  
  demux : process (demux_in, demux_sel)
    variable tmp_demux_out : dlx_word;
  begin
    tmp_demux_out := To_StdLogicVector(X"ffff_ffff");
    case demux_sel is
      when "00000" => tmp_demux_out(0) := demux_in ;
      when "00001" => tmp_demux_out(1) := demux_in ;
      when "00010" => tmp_demux_out(2) := demux_in ;
      when "00011" => tmp_demux_out(3) := demux_in ;
      when "00100" => tmp_demux_out(4) := demux_in ;
      when "00101" => tmp_demux_out(5) := demux_in ;
      when "00110" => tmp_demux_out(6) := demux_in ;
      when "00111" => tmp_demux_out(7) := demux_in ;
      when "01000" => tmp_demux_out(8) := demux_in ;
      when "01001" => tmp_demux_out(9) := demux_in ;
      when "01010" => tmp_demux_out(10) := demux_in ;
      when "01011" => tmp_demux_out(11) := demux_in ;
      when "01100" => tmp_demux_out(12) := demux_in ;
      when "01101" => tmp_demux_out(13) := demux_in ;
      when "01110" => tmp_demux_out(14) := demux_in ;
      when "01111" => tmp_demux_out(15) := demux_in ;
      when "10000" => tmp_demux_out(16) := demux_in ;
      when "10001" => tmp_demux_out(17) := demux_in ;
      when "10010" => tmp_demux_out(18) := demux_in ;
      when "10011" => tmp_demux_out(19) := demux_in ;
      when "10100" => tmp_demux_out(20) := demux_in ;
      when "10101" => tmp_demux_out(21) := demux_in ;	  
      when "10110" => tmp_demux_out(22) := demux_in ;
      when "10111" => tmp_demux_out(23) := demux_in ;
      when "11000" => tmp_demux_out(24) := demux_in ;
      when "11001" => tmp_demux_out(25) := demux_in ;
      when "11010" => tmp_demux_out(26) := demux_in ;
      when "11011" => tmp_demux_out(27) := demux_in ;
      when "11100" => tmp_demux_out(28) := demux_in ;
      when "11101" => tmp_demux_out(29) := demux_in ;
      when "11110" => tmp_demux_out(30) := demux_in ;
      when "11111" => tmp_demux_out(31) := demux_in ;
      when others  => null; 
    end case;
    demux_out <= tmp_demux_out after tpd_demux;
  end process demux;

end behaviour;



