--------------------------------------------------------------------------
--  DLX PROCESSOR MODEL SUITE
--  Copyright (C) 1995, Martin Gumm
--  University of Stuttgart / Department of Computer Science / IPVR-ISE
--------------------------------------------------------------------------
--  This program is free software; you can redistribute it and/or modify
--  it under the terms of the GNU General Public License as published by
--  the Free Software Foundation; either version 1, or (at your option)
--  any later version.
--
--  This program is distributed in the hope that it will be useful,
--  but WITHOUT ANY WARRANTY; without even the implied warranty of
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--  GNU General Public License for more details.
--------------------------------------------------------------------------
--  Last revision date : November 15 1995
--------------------------------------------------------------------------

--------------------------------------------------------------------------
--  *** SYNOPSYS synthesizable code (ver. 3.2.a) ***
--------------------------------------------------------------------------

--------------------------------------------------------------------------
--  Entity declaration for the datapath
--
--  (file datapath.vhd)
--------------------------------------------------------------------------

library IEEE;
use IEEE.std_logic_1164.all;

use WORK.dlx_types.all;

entity datapath is
  port(signal data_in      : in  dlx_word;           -- data in from pads
       signal data_out     : out dlx_word;           -- data_out to pads
       signal addr_out     : out dlx_word;           -- addr. out to pads
       signal instr_out    : out dlx_word;           -- instr. reg. content
       signal alu_zero     : out std_logic;                     
       signal alu_negative : out std_logic;
       signal alu_overflow : out std_logic;
       signal icr_intrpt   : out std_logic;          -- at least one masked intrpt.
       signal icr_super    : out std_logic;          -- supervisor bit in icr
       signal mar_adr_ls2  : out std_logic_vector(0 to 1); -- least 2 addr. bits
       signal mar_adr_msb  : out std_logic;          --  msb of mar
       --
       -- reg. addr. inputs
       --
       signal reg_addr_rs1 : in dlx_reg_addr;
       signal reg_addr_rs2 : in dlx_reg_addr;
       signal reg_addr_rd  : in dlx_reg_addr;
       --
       -- control inputs
       --
       signal a_latch_en  : in std_logic;         -- low active
       signal a_out_en    : in std_logic;         -- low active
       signal b_latch_en  : in std_logic;         -- low active
       signal b_out_en    : in std_logic;         -- low active
       signal c_latch_en  : in std_logic;         -- low active
       signal regf_wr_en  : in std_logic;         -- low active

       signal mar_latch_en : in std_logic;        -- low active
       signal mar_out1_en  : in std_logic;        -- low active
       signal mdr_latch_en : in std_logic;        -- low active
       signal mdr_out1_en  : in std_logic;        -- low active
       signal mdr_sh_ctrl  : in std_logic_vector(0 to 2); -- enab signal for shift op.

       signal pc_latch_en  : in std_logic;        -- low active
       signal pc_out_en    : in std_logic;        -- low active
       signal iar_latch_en : in std_logic;        -- low active
       signal iar_out_en   : in std_logic;        -- low active
       signal tbr_latch_en : in std_logic;        -- low active
       signal tbr_out_en   : in std_logic;        -- low active

       signal icr_out_en   : in std_logic;        -- low active
       signal icr_latch_en : in std_logic;        -- low active
       signal icr_s_en     : in std_logic;        -- enab set s bit (low act.)
       signal icr_ioc_en   : in std_logic;        -- enab set ioc bit (low act.)
       signal icr_irra_en  : in std_logic;        -- enab set irra bit(low act.)
       signal icr_iav_en   : in std_logic;        -- enab set iav bit (low act.)
       signal icr_dav_en   : in std_logic;        -- enab set dav bit (low act.)
       signal icr_ovad_en   : in std_logic;       -- enab set ovad bit(low act.)
       signal icr_ovar_en   : in std_logic;       -- enab set ovar bit(low act.)
       signal icr_priv_en   : in std_logic;       -- enab set priv bit (low act.)
       signal icr_intrpt_in : in dlx_nibble;      -- intrpt. input from pads
       signal icr_intrpt_en : in std_logic;       -- enable setting of intrpt bits 

       signal ir_latch_en    : in std_logic;      -- low active
       signal ir_immed_o1_en : in std_logic;      -- low active
       signal ir_immed_o2_en : in std_logic;      -- low active
       signal ir_immed_size  : in std_logic;      -- '0'-> 16 bit / '1'-> 26 bit
       signal ir_immed_sign  : in std_logic;      -- '0'-> unsign./ '1'-> sign.  

       signal alu_latch_en : in std_logic;        -- low active
       signal alu_func     : in dlx_nibble;

       signal addr_mux_sel : in std_logic;        -- '0' : pc->out/ '1' : mar->out
       signal mdr_mux_sel  : in std_logic;        -- '0' : dest->mdr/ '1' : mem->mdr
       
       signal const_o1_en : in std_logic;         -- enable constant for s1 (low act.)
       signal const_o2_en : in std_logic;         -- enable constant for s2 (low act.)
       signal const_sel   : in std_logic_vector(0 to 1));  -- select constant
              
end datapath;



