--------------------------------------------------------------------------
--  DLX PROCESSOR MODEL SUITE
--  Copyright (C) 1995, Martin Gumm
--  University of Stuttgart / Department of Computer Science / IPVR-ISE
--------------------------------------------------------------------------
--  This program is free software; you can redistribute it and/or modify
--  it under the terms of the GNU General Public License as published by
--  the Free Software Foundation; either version 1, or (at your option)
--  any later version.
--
--  This program is distributed in the hope that it will be useful,
--  but WITHOUT ANY WARRANTY; without even the implied warranty of
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--  GNU General Public License for more details.
--------------------------------------------------------------------------
--  Last revision date : November 15 1995
--------------------------------------------------------------------------

--------------------------------------------------------------------------
--  *** SYNOPSYS synthesizable code (ver. 3.2.a) ***
--------------------------------------------------------------------------

--------------------------------------------------------------------------
--  Configuration for the DLX 
--  
--  (file datapath_config1.vhd)
--------------------------------------------------------------------------

configuration datapath_config1 OF datapath IS

  for structural

    for dp_alu : alu
      USE ENTITY WORK.alu(behaviour)
      --USE configuration WORK.alu_config_rtl
        GENERIC MAP (tpd_latch => 2 ns,
                     tpd_out => 10 ns);
    end for; -- dp_alu
  	    
    for dp_reg_file : reg_file
      USE ENTITY WORK.reg_file(behaviour_2)
      --USE configuration WORK.reg_file_config_rtl
        GENERIC MAP (tpd_in => 4 ns,
                     tac => 4 ns);
    end for; -- dp_reg_file

    for a_reg, b_reg, iar_reg, tbr_reg : word_reg_1e
      USE ENTITY WORK.word_reg_1e(dataflow)
	GENERIC MAP (tpd_latch => 2 ns,
	             tpd_out => 2 ns);
    end for; -- areg ...

    for pc_reg, mar_reg : word_reg_1e1
      USE ENTITY WORK.word_reg_1e1(dataflow)
	GENERIC MAP (tpd_latch => 2 ns,
	             tpd_out => 2 ns);
    end for; -- pc_reg ...

    for mdr_reg : mdr
      USE ENTITY WORK.mdr(behaviour)
	GENERIC MAP (tpd_latch => 2 ns,
	             tpd_out => 2 ns,
		     tpd_logic => 2 ns);
    end for; -- mdr

    FOR c_reg : word_latch
      USE ENTITY WORK.word_latch(dataflow)
	GENERIC MAP (tpd_latch => 2 ns);
    end for; -- c_latch

    FOR icr_reg : icr
      USE ENTITY WORK.icr(dataflow)
	GENERIC MAP (tpd_latch => 2 ns,
	             tpd_out => 2 ns);
    end for; -- icr_reg

    FOR instr_reg : ir
      USE ENTITY WORK.ir(behaviour)
	GENERIC MAP (tpd_latch => 2 ns,
      	             tpd_out => 4 ns,	
	             DEBUG => true);
    end for; -- instr_reg

    FOR addr_mux, mdr_mux : word_mux2
      USE ENTITY WORK.word_mux2(dataflow)
	GENERIC MAP (tpd_out => 2 ns);
    end for; -- addr_mux ...

    FOR bus_const : bus_const32
      USE ENTITY WORK.bus_const32(dataflow)
	GENERIC MAP (tpd_out => 2 ns);
    end for; -- bus_const

  end for; -- datapath-structural

end datapath_config1;
