--------------------------------------------------------------------------
--  DLX PROCESSOR MODEL SUITE
--  Copyright (C) 1995, Martin Gumm
--  University of Stuttgart / Department of Computer Science / IPVR-ISE
--------------------------------------------------------------------------
--  This program is free software; you can redistribute it and/or modify
--  it under the terms of the GNU General Public License as published by
--  the Free Software Foundation; either version 1, or (at your option)
--  any later version.
--
--  This program is distributed in the hope that it will be useful,
--  but WITHOUT ANY WARRANTY; without even the implied warranty of
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--  GNU General Public License for more details.
--------------------------------------------------------------------------
--  Last revision date : November 15 1995
--------------------------------------------------------------------------

--------------------------------------------------------------------------
--  *** SYNOPSYS synthesizable code (ver. 3.2.a) ***
--------------------------------------------------------------------------

--------------------------------------------------------------------------
--  Package for the data types and microcode used in the controller 
--  
--  (file control_types.vhd)
--------------------------------------------------------------------------

library IEEE;
USE IEEE.std_logic_1164.ALL;

package control_types is

  --
  -- finite state names (64 different states)
  --
  type fsm_states is (reset_1, reset_2, fetch, decode_pcincr_ab, memory,
                      load_w_1, load_w_2, load_h_1, load_h_2, load_b_1,
 		      load_b_2, store_w_1, store_w_2,  store_h_1, store_h_2,
 		      store_b_1, store_b_2, lhi, movi2s, movs2i, br_eqz, br_nez,
 		      branch, jump, jump_lnk_1, jump_lnk_2, jump_reg, jump_lnk_reg_1,
 		      jump_lnk_reg_2, trap_1, trap_2, trap_3, rfe_1, rfe_2, load_pc,
 		      add_1, sub_1, and_1, or_1, xor_1, sll_1, srl_1, sra_1, seq_1,
 		      sne_1, slt_1, sle_1, sgt_1, sge_1, set_to_1, set_to_0,
 		      write_back, intrpt_1, intrpt_2, intrpt_3, ill_opc,
 		      ill_rraf, d_adr_viol, i_adr_viol, priv_viol,
 		      except_ovad, except_ovar, halt_state, error_state);
  --
  -- source for s1 bus (low activ signals)
  -- |a|icr|iar|tbr|X|mdr|immed|consta| (b/pc/mar not connected to s1 bus)
  -- X : icr or iar or tbr, for mov instructions
  --
  constant s1_a     : std_logic_vector(0 to 7) := "01111111";
  constant s1_icr   : std_logic_vector(0 to 7) := "10111111";
  constant s1_iar   : std_logic_vector(0 to 7) := "11011111";
  constant s1_tbr   : std_logic_vector(0 to 7) := "11101111";
  constant s1_X     : std_logic_vector(0 to 7) := "11110111";
  constant s1_mdr   : std_logic_vector(0 to 7) := "11111011";
  constant s1_immed : std_logic_vector(0 to 7) := "11111101";
  constant s1_const : std_logic_vector(0 to 7) := "11111110";
  constant s1_none  : std_logic_vector(0 to 7) := "11111111"; -- don't care not allowed
                                                              -- (only one driver !)
  --
  -- source for s2 bus (low activ signals)
  -- |b|immed|Y|pc|mar|constb|
  -- (a/mdr/icr/tbr/iar not connected to s2 bus)
  -- Y : b or immed, depends on instruction
  -- adr_ctrl : switch address for s2 bus when store Rtype instr.
  --
  constant s2_b      : std_logic_vector(0 to 5) := "011111";  
  constant s2_immed  : std_logic_vector(0 to 5) := "101111";  
  constant s2_Y      : std_logic_vector(0 to 5) := "110111";  
  constant s2_pc     : std_logic_vector(0 to 5) := "111011";
  constant s2_mar    : std_logic_vector(0 to 5) := "111101";
  constant s2_const  : std_logic_vector(0 to 5) := "111110";
  constant s2_none   : std_logic_vector(0 to 5) := "111111"; -- don't care not allowed
                                                             -- (only one driver !)
  --
  -- destination from dest bus (low activ signals)
  -- |c|icr|iar|tbr|X|pc|mar|mdr|
  -- X : icr or iar or tbr, for mov instruction
  --
  constant dest_c     : std_logic_vector(0 to 7) := "01111111";
  constant dest_icr   : std_logic_vector(0 to 7) := "10111111";
  constant dest_iar   : std_logic_vector(0 to 7) := "11011111";
  constant dest_tbr   : std_logic_vector(0 to 7) := "11101111";
  constant dest_X     : std_logic_vector(0 to 7) := "11110111"; -- same as dest_none
  constant dest_pc    : std_logic_vector(0 to 7) := "11111011";
  constant dest_mar   : std_logic_vector(0 to 7) := "11111101";
  constant dest_mdr   : std_logic_vector(0 to 7) := "11111110";
  constant dest_res   : std_logic_vector(0 to 7) := "10000000"; -- don't care not allowed
  constant dest_none  : std_logic_vector(0 to 7) := "11111111";
  --
  -- select constant 
  -- |sel_const(0:1)|
  --
  constant const_00    : std_logic_vector(0 to 1) := "00";
  constant const_01    : std_logic_vector(0 to 1) := "01";
  constant const_04    : std_logic_vector(0 to 1) := "10";
  constant const_10    : std_logic_vector(0 to 1) := "01";
  constant const_18    : std_logic_vector(0 to 1) := "10";
  constant const_dcare : std_logic_vector(0 to 1) := "--";
  --
  -- select immediate
  -- |size_imm|sign_imm|
  --
  constant imm_s16   : std_logic_vector(0 to 1) := "01";
  constant imm_u16   : std_logic_vector(0 to 1) := "00";
  constant imm_s26   : std_logic_vector(0 to 1) := "11";
  constant imm_u26   : std_logic_vector(0 to 1) := "10";
  constant imm_dcare : std_logic_vector(0 to 1) := "--";
  --
  -- register file operation
  -- (ab<-rf, rf<-c)
  -- |ab_rf|ab_rf_x|rf_c|
  --
  constant rfop_none   : std_logic_vector(0 to 2) := "111";
  constant rfop_ab_rf  : std_logic_vector(0 to 2) := "011";
  constant rfop_ab_rfx : std_logic_vector(0 to 2) := "001";
  constant rfop_rf_c   : std_logic_vector(0 to 2) := "110";
  constant rfop_dcare  : std_logic_vector(0 to 2) := "-11";
  --
  -- alu operation
  --
  constant alu_pass_s1   : std_logic_vector(0 to 3) := "0000";
  constant alu_pass_s2   : std_logic_vector(0 to 3) := "0001";
  constant alu_s1_add_s2 : std_logic_vector(0 to 3) := "0100";
  constant alu_s1_sub_s2 : std_logic_vector(0 to 3) := "0101";
  constant alu_sll_s1_s2 : std_logic_vector(0 to 3) := "1000";
  constant alu_srl_s1_s2 : std_logic_vector(0 to 3) := "1010";
  constant alu_sra_s1_s2 : std_logic_vector(0 to 3) := "1011";
  constant alu_s1_and_s2 : std_logic_vector(0 to 3) := "1100";
  constant alu_s1_or_s2  : std_logic_vector(0 to 3) := "1101";
  constant alu_s1_xor_s2 : std_logic_vector(0 to 3) := "1110";
  constant alu_dcare     : std_logic_vector(0 to 3) := "----";
  --
  -- exception bit enable or setting
  -- |set_s|ioc|irra|iav|dav|ovad|ovar|priv|
  --  
  constant exc_none  : std_logic_vector(0 to 7) := "11111111";
  constant exc_sbit  : std_logic_vector(0 to 7) := "01111111";
  constant exc_ioc   : std_logic_vector(0 to 7) := "10111111";
  constant exc_irra  : std_logic_vector(0 to 7) := "11011111";
  constant exc_iav   : std_logic_vector(0 to 7) := "11101111";
  constant exc_dav   : std_logic_vector(0 to 7) := "11110111";
  constant exc_ovad  : std_logic_vector(0 to 7) := "11111011";
  constant exc_ovar  : std_logic_vector(0 to 7) := "11111101";
  constant exc_priv  : std_logic_vector(0 to 7) := "11111110";
  --
  -- memory control signals (ir_en, pad_out_en : low active)
  -- |ir_en|addr_mux|mdr_mux|dec_enab(0 to 1)|rw|pad_d_inout|pad_out_en|error|
  --
  -- dec_enab(0 to 1) : "11" = word access
  --                    "10" = half "
  --                    "01" = byte "
  --                    "00" = no access
  --
  constant mem_none  : std_logic_vector(0 to 8) := "100001100";
  constant mem_fetch : std_logic_vector(0 to 8) := "000111100";
  constant mem_ldst  : std_logic_vector(0 to 8) := "110000100";
  constant mem_lw    : std_logic_vector(0 to 8) := "111111100";
  constant mem_lh    : std_logic_vector(0 to 8) := "111101100";
  constant mem_lb    : std_logic_vector(0 to 8) := "111011100";
  constant mem_sw    : std_logic_vector(0 to 8) := "110110000";
  constant mem_sh    : std_logic_vector(0 to 8) := "110100000";
  constant mem_sb    : std_logic_vector(0 to 8) := "110010000";
  constant mem_halt  : std_logic_vector(0 to 8) := "100001110";
  constant mem_error : std_logic_vector(0 to 8) := "100001101";  

  --
  -- mdr shift control signals
  -- (not used in finite state machine, only ir_decoder_2 )
  --
  constant mdr_ctrl_none : std_logic_vector(0 to 2) := "0--";
  constant mdr_ctrl_lh   : std_logic_vector(0 to 2) := "100";
  constant mdr_ctrl_lb   : std_logic_vector(0 to 2) := "101";
  constant mdr_ctrl_sh   : std_logic_vector(0 to 2) := "110";
  constant mdr_ctrl_sb   : std_logic_vector(0 to 2) := "111";
  
end control_types;

