--------------------------------------------------------------------------
--  DLX PROCESSOR MODEL SUITE
--  Copyright (C) 1995, Martin Gumm
--  University of Stuttgart / Department of Computer Science / IPVR-ISE
--------------------------------------------------------------------------
--  This program is free software; you can redistribute it and/or modify
--  it under the terms of the GNU General Public License as published by
--  the Free Software Foundation; either version 1, or (at your option)
--  any later version.
--
--  This program is distributed in the hope that it will be useful,
--  but WITHOUT ANY WARRANTY; without even the implied warranty of
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--  GNU General Public License for more details.
--------------------------------------------------------------------------
--  Last revision date : November 15 1995
--------------------------------------------------------------------------

--------------------------------------------------------------------------
--  *** SYNOPSYS synthesizable code (ver. 3.2.a) ***
--------------------------------------------------------------------------

--------------------------------------------------------------------------
--  architecture of the cla b-block
--
--  (file cla_b-dataflow.vhd)
--------------------------------------------------------------------------

architecture dataflow of cla_b is
  signal g_0_3, g_4_7, p_0_3, p_4_7 : std_logic;
  signal c4_tmp: std_logic;
begin
  c2 <= g_0_1 or (p_0_1 and  c_in);
  p_0_3 <= p_0_1 and p_2_3;
  g_0_3 <= g_2_3 or (p_2_3 and g_0_1);
  --
  c6 <= g_4_5 or (p_4_5 and c4_tmp);
  p_4_7 <= p_4_5 and p_6_7;
  g_4_7 <= g_6_7 or (p_6_7 and g_4_5);
  --
  c4_tmp <= g_0_3 or (p_0_3 and c_in);
  p_n <= p_0_3 and p_4_7;
  g_n <= g_4_7 or (p_4_7 and g_0_3);
  --
  c0 <= c_in;
  c4 <= c4_tmp;

end dataflow;

