--------------------------------------------------------------------------
--  DLX PROCESSOR MODEL SUITE
--  Copyright (C) 1995, Martin Gumm
--  University of Stuttgart / Department of Computer Science / IPVR-ISE
--------------------------------------------------------------------------
--  This program is free software; you can redistribute it and/or modify
--  it under the terms of the GNU General Public License as published by
--  the Free Software Foundation; either version 1, or (at your option)
--  any later version.
--
--  This program is distributed in the hope that it will be useful,
--  but WITHOUT ANY WARRANTY; without even the implied warranty of
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--  GNU General Public License for more details.
--------------------------------------------------------------------------
--  Last revision date : November 15 1995
--------------------------------------------------------------------------

--------------------------------------------------------------------------
--  *** SYNOPSYS synthesizable code (ver. 3.2.a) ***
--------------------------------------------------------------------------

--------------------------------------------------------------------------
--  architecture of the cla a-block
--
--  (file cla_a-dataflow.vhd)
--------------------------------------------------------------------------

architecture dataflow of cla_a is
  signal c1 : std_logic;
begin
  s0 <= (a0 xor b0) xor c0;
  c1 <= (a0 and b0) or (a0 and c0) or (b0 and c0);
  s1 <= (a1 xor b1) xor c1;
  p_n <= not ((not a1 and not b1) or (not a0 and not b0));
  g_n <= (a1 and b1) or ((a0 and b0) and (a1 or b1));
end dataflow;
