--------------------------------------------------------------------------
--  DLX PROCESSOR MODEL SUITE
--  Copyright (C) 1995, Martin Gumm
--  University of Stuttgart / Department of Computer Science / IPVR-ISE
--------------------------------------------------------------------------
--  This program is free software; you can redistribute it and/or modify
--  it under the terms of the GNU General Public License as published by
--  the Free Software Foundation; either version 1, or (at your option)
--  any later version.
--
--  This program is distributed in the hope that it will be useful,
--  but WITHOUT ANY WARRANTY; without even the implied warranty of
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--  GNU General Public License for more details.
--------------------------------------------------------------------------
--  Last revision date : November 15 1995
--------------------------------------------------------------------------

--------------------------------------------------------------------------
--  *** SYNOPSYS synthesizable code (ver. 3.2.a) ***
--------------------------------------------------------------------------

--------------------------------------------------------------------------
--  Entity declaration for 32-bit constants with select 
--
--  (file bus_const32.vhd)
--------------------------------------------------------------------------

--------------------------------------------------------------------------
-- out_en1, out_en2 : low active
--------------------------------------------------------------------------
-- select(0 to 1) : "00"  q1 = X"0000_0000" when enabled 
--                  "01"  q1 = X"0000_0001" when enabled 
--                  "10"  q1 = X"0000_0004" when enabled 
-- select(0 to 1)   "00   q2 = X"0000_0000" when enabled 
--                  "01"  q2 = X"0000_0010" when enabled
--                  "10"  q2 = X"0000_0018" when enabled
--------------------------------------------------------------------------

library IEEE;
use IEEE.std_logic_1164.all;

use WORK.dlx_types.all;

entity bus_const32 is
  generic (tpd_out : Time);
  port (q1 : out dlx_word;
        q2 : out dlx_word;
	out_en1 : in std_logic;
	out_en2 : in std_logic;
	sel     : in std_logic_vector(0 to 1));
end bus_const32;
