--------------------------------------------------------------------------
--  DLX PROCESSOR MODEL SUITE
--  Copyright (C) 1995, Martin Gumm
--  University of Stuttgart / Department of Computer Science / IPVR-ISE
--------------------------------------------------------------------------
--  This program is free software; you can redistribute it and/or modify
--  it under the terms of the GNU General Public License as published by
--  the Free Software Foundation; either version 1, or (at your option)
--  any later version.
--
--  This program is distributed in the hope that it will be useful,
--  but WITHOUT ANY WARRANTY; without even the implied warranty of
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--  GNU General Public License for more details.
--------------------------------------------------------------------------
--  Last revision date : November 15 1995
--------------------------------------------------------------------------

--------------------------------------------------------------------------
--  *** SYNOPSYS synthesizable code (ver. 3.2.a) ***
--------------------------------------------------------------------------

--------------------------------------------------------------------------
--  Configuration for the ALU
--
--  (file alu-config_rtl.vhd)
--------------------------------------------------------------------------

configuration alu_config_rtl of alu is

  for structural

    FOR latch_s1, latch_s2 : word_latch
      USE ENTITY WORK.word_latch(dataflow)
	GENERIC MAP (tpd_latch => 2 ns);
    end for; -- c_latch

    for the_adder : word_adder
      use entity WORK.word_adder(cla_h)
        generic map (tpd_out => 18 ns);

      for cla_h

	for all : cla_a
	  use entity WORK.cla_a(dataflow);
	end for; -- cla_a

	for all : cla_b
	  use entity WORK.cla_b(dataflow);
	end for; -- cla_b

	for b_end : cla_b_end
	  use entity WORK.cla_b_end(dataflow);
	end for; -- cla_b_end

      end for; -- cla_h

    end for; -- the_adder
 
    for the_shifter : word_shifter
      use entity WORK.word_shifter(behaviour)
        generic map (tpd_out => 18 ns);
    end for; -- the_shifter

    for the_alu_logic : word_alu_logic
      use entity WORK.word_alu_logic(behaviour)
        generic map (tpd_out => 5 ns);
    end for; -- the_alu_logic

    FOR the_pass_mux : word_mux2
      USE ENTITY WORK.word_mux2(dataflow)
	gENERIC MAP (tpd_out => 2 ns);
    end for; -- the_pass_mux

    FOR the_out_mux : word_mux4
      USE ENTITY WORK.word_mux4(dataflow)
	gENERIC MAP (tpd_out => 4 ns);
    end for; -- the_out_mux

  end for; -- structural

end alu_config_rtl;


