--------------------------------------------------------------------------
--  DLX PROCESSOR MODEL SUITE
--  Copyright (C) 1995, Martin Gumm
--  University of Stuttgart / Department of Computer Science / IPVR-ISE
--------------------------------------------------------------------------
--  This program is free software; you can redistribute it and/or modify
--  it under the terms of the GNU General Public License as published by
--  the Free Software Foundation; either version 1, or (at your option)
--  any later version.
--
--  This program is distributed in the hope that it will be useful,
--  but WITHOUT ANY WARRANTY; without even the implied warranty of
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--  GNU General Public License for more details.
--------------------------------------------------------------------------
--  Last revision date : November 15 1995
--------------------------------------------------------------------------

--------------------------------------------------------------------------
--  *** SYNOPSYS synthesizable code (ver. 3.2.a) ***
--------------------------------------------------------------------------

--------------------------------------------------------------------------
--   behaviour architecture for memory data register (32-bit)
--   with one tri-state output and one normal output 
--  (register with special shift capabilities)
--  => this coding style does not result in good synthesis results !!!
--
--  (file mdr-behaviour_nogood.vhd)
--------------------------------------------------------------------------

architecture behaviour_nogood of mdr is
  signal latch_value : dlx_word;

begin
  lat : process (d, latch_en, rw_op, mem_op)
  begin
    if latch_en = '0' then
      if rw_op = '0' then                        -- load operation
	case mem_op is
	  when "1111" |                          -- load word
	       "1100" |                          -- load ms-half
	       "1000" =>                         -- load ms-byte 0
	    --
	    -- load unchanged from input
	    --
	    latch_value <= To_UX01(d) after tpd_latch;
 	  when "0011" |                           -- load ls-half
	       "0010" =>                          -- load byte 2
	    --
	    -- load lower half into upper half
	    --
	    latch_value(0 to 15) <= To_UX01(d(16 to 31)) after tpd_latch;
	  when "0100" =>                          -- load byte 1
	    --
	    -- load byte 1 into byte 0
	    --
	    latch_value(0 to 7) <= To_UX01(d(8 to 15)) after tpd_latch;
	  when "0001" =>                          -- load byte 3
	    --
	    -- load byte 3 into byte 0
	    --
	    latch_value(0 to 7) <= To_UX01(d(24 to 31)) after tpd_latch;
	  when others =>
	    null;
	end case;
      else                                        -- store operation
	case mem_op is
	  when "1111" |                           -- store word
	       "0011" |                           -- store ls-half
	       "0001" =>                          -- store ls-byte 3
	    --
	    -- load unchanged from input
	    --
	    latch_value <= To_UX01(d) after tpd_latch;
 	  when "1100" |                           -- store ms-half
	       "0100" =>                          -- store byte 1
	    --
	    -- load lower half into upper half
	    --
	    latch_value(0 to 15) <= To_UX01(d(16 to 31)) after tpd_latch;
	  when "0010" =>                          -- store byte 2
	    --
	    -- load byte 3 into byte 2
	    --
	    latch_value(16 to 23) <= To_UX01(d(24 to 31)) after tpd_latch;
	  when "1000" =>                          -- store byte 0
	    --
	    -- load byte 3 into byte 0
	    --
	    latch_value(0 to 7) <= To_UX01(d(24 to 31)) after tpd_latch;
	  when others =>
	    null;
	end case;
      end if;
    end if;
  end process lat;

  q1 <= latch_value after tpd_out when out_en1 = '0' else
        (others => 'Z') after tpd_out;

  q2 <= latch_value;
  
end behaviour_nogood;





