--------------------------------------------------------------------------
--  DLX PROCESSOR MODEL SUITE
--  Copyright (C) 1995, Martin Gumm
--  University of Stuttgart / Department of Computer Science / IPVR-ISE
--------------------------------------------------------------------------
--  This program is free software; you can redistribute it and/or modify
--  it under the terms of the GNU General Public License as published by
--  the Free Software Foundation; either version 1, or (at your option)
--  any later version.
--
--  This program is distributed in the hope that it will be useful,
--  but WITHOUT ANY WARRANTY; without even the implied warranty of
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--  GNU General Public License for more details.
--------------------------------------------------------------------------
--  Last revision date : November 15 1995
--------------------------------------------------------------------------

--------------------------------------------------------------------------
--  *** SYNOPSYS synthesizable code ***
--------------------------------------------------------------------------

--------------------------------------------------------------------------
--  Entity declaration for the left shifter
--
--  (file lshift.vhd)
--------------------------------------------------------------------------

library IEEE;
use IEEE.std_logic_1164.all;

libary IEEE_EXTD;
use IEEE_EXTD.stdl1164_vector_arithmetic.all;

use WORK.dlx_types.all;

entity lshift is
  generic (tpd_out : Time);
  port (a : in dlx_word;
      	b : out dlx_word;
	shift : std_logic_vector(0 to 4));
end lshift;

