--------------------------------------------------------------------------
--  DLX PROCESSOR MODEL SUITE
--  Copyright (C) 1995, Martin Gumm
--  University of Stuttgart / Department of Computer Science / IPVR-ISE
--------------------------------------------------------------------------
--  This program is free software; you can redistribute it and/or modify
--  it under the terms of the GNU General Public License as published by
--  the Free Software Foundation; either version 1, or (at your option)
--  any later version.
--
--  This program is distributed in the hope that it will be useful,
--  but WITHOUT ANY WARRANTY; without even the implied warranty of
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--  GNU General Public License for more details.
--------------------------------------------------------------------------
--  Last revision date : November 15 1995
--------------------------------------------------------------------------

--------------------------------------------------------------------------
--   Dataflow architecture for ICR register (32-bit)
--   with one tri-state output ond
--   additional bit load function for ICR(26 to 31)
--
--  (file icr-dataflow_block.vhd)
--------------------------------------------------------------------------

architecture dataflow_block of icr is
  signal icr_value : dlx_word;

begin
  --
  -- bits that are always 0
  --
  icr_value(8 to 15) <= "00000000";
  icr_value(24 to 25) <= "00";

  --
  -- exception bits
  --
  ioc_bit : block(ioc_en = '0')
  begin
    icr_value(31) <= guarded exc_sr after tpd_latch;            -- exc_sr : set or reset bit
  end block;

  irra_bit : block(irra_en = '0')
  begin
    icr_value(30) <= guarded exc_sr after tpd_latch;            -- exc_sr : set or reset bit
  end block;

  iav_bit : block(iav_en = '0')
  begin
    icr_value(29) <= guarded exc_sr after tpd_latch;            -- exc_sr : set or reset bit
  end block;

  dav_bit : block(dav_en = '0')
  begin
    icr_value(28) <= guarded exc_sr after tpd_latch;            -- exc_sr : set or reset bit
  end block;

  ovad_bit : block(ovad_en = '0')
  begin
    icr_value(27) <= guarded exc_sr AND ovfl_in after tpd_latch; -- exc_sr : enable ovfl_in
  end block;

  ovar_bit : block(ovar_en = '0')
  begin
    icr_value(26) <= guarded exc_sr AND ovfl_in after tpd_latch; -- exc_sr : enable ovfl_in
  end block;

  --
  -- interrupt bits
  -- (bits are initialized with value from intrpt_in when icr is loaded)
  --
  intrpt0_bit : block((intrpt_in(0) = '1' and intrpt_en = '1') or latch_en = '0')
  begin
    icr_value(16) <= guarded To_UX01(intrpt_in(0)) after tpd_latch;
  end block;

  intrpt1_bit : block((intrpt_in(1) = '1' and intrpt_en = '1') or latch_en = '0')
  begin
    icr_value(17) <= guarded To_UX01(intrpt_in(1)) after tpd_latch;
  end block;

  intrpt2_bit : block((intrpt_in(2) = '1' and intrpt_en = '1') or latch_en = '0')
  begin
    icr_value(18) <= guarded To_UX01(intrpt_in(2)) after tpd_latch;
  end block;

  intrpt3_bit : block((intrpt_in(3) = '1' and intrpt_en = '1') or latch_en = '0')
  begin
    icr_value(19) <= guarded To_UX01(intrpt_in(3)) after tpd_latch;
  end block;
  
  --
  -- mask bits and saved interrupt information
  --
  other_bits : block(latch_en = '0')
  begin
    icr_value(0 to 7) <= guarded To_UX01(d(0 to 7)) after tpd_latch;
    icr_value(20 to 23) <= guarded To_UX01(d(20 to 23)) after tpd_latch; 
  end block;

  --
  -- outputs
  --
  q <= icr_value after tpd_out when out_en = '0' else
       (others => 'Z') after tpd_out;
	 
  except <= icr_value(26) or icr_value(27) or icr_value(28) or
               icr_value(29) or icr_value(30) or icr_value(31) after tpd_out;

  intrpt <= (icr_value(16) and icr_value(20)) or
            (icr_value(17) and icr_value(21)) or
	    (icr_value(18) and icr_value(22)) or
	    (icr_value(19) and icr_value(23)) after tpd_out;
  	    
end dataflow_block;
