--------------------------------------------------------------------------
--  DLX PROCESSOR MODEL SUITE
--  Copyright (C) 1995, Martin Gumm
--  University of Stuttgart / Department of Computer Science / IPVR-ISE
--------------------------------------------------------------------------
--  This program is free software; you can redistribute it and/or modify
--  it under the terms of the GNU General Public License as published by
--  the Free Software Foundation; either version 1, or (at your option)
--  any later version.
--
--  This program is distributed in the hope that it will be useful,
--  but WITHOUT ANY WARRANTY; without even the implied warranty of
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--  GNU General Public License for more details.
--------------------------------------------------------------------------
--  Last revision date : November 15 1995
--------------------------------------------------------------------------

--------------------------------------------------------------------------
--  Package declaration for the procedures used in the behavioural
--  descriptions of DLX processor
--  (for the architecture behaviour_4)
--  
--  (file behav_procedures_4.vhd)
--------------------------------------------------------------------------

LIBRARY IEEE;
USE IEEE.std_logic_1164.ALL;

USE WORK.dlx_types.ALL;

USE STD.textio.ALL;

PACKAGE behav_procedures_4 IS

  -----------------------------------------------------------------
  -- procedure for reading from the data bus 
  -----------------------------------------------------------------
  PROCEDURE bus_read (address    : IN dlx_address;
                      data_width : IN mem_ACCESS_TYPE;
		      data       : OUT dlx_word;
		      --
		      INT           : INOUT dlx_nibble;
		      signal intrpt : IN dlx_nibble;
		      --
		      signal phi1, phi2 : IN std_logic;
                      signal addr_bus   : OUT dlx_address;
		      signal data_bus   : INOUT dlx_word;
		      signal reset      : IN std_logic;
		      signal ready      : IN std_logic;
		      signal rw         : OUT std_logic;
		      signal enable     : OUT dlx_nibble;
		      --
		      tpd_behav : IN time);
			
  -----------------------------------------------------------------
  -- procedure for writing on the data bus 
  -----------------------------------------------------------------
  PROCEDURE bus_write (address    : IN dlx_address;
		       data_width : IN mem_ACCESS_TYPE;
                       data       : IN dlx_word;
		       --
		       INT           : INOUT dlx_nibble;
		       signal intrpt : IN dlx_nibble;
		       --
		       signal phi1, phi2 : IN std_logic;
                       signal addr_bus   : OUT dlx_address;
		       signal data_bus   : INOUT dlx_word;
		       signal reset      : IN std_logic;
		       signal ready      : IN std_logic;
		       signal rw         : OUT std_logic;
		       signal enable     : OUT dlx_nibble;
		       --
		       tpd_behav : IN time);
		       
  -----------------------------------------------------------------
  -- procedure for checking the interrupt lines 
  -----------------------------------------------------------------
  PROCEDURE intrpt_check (signal phi2   : IN std_logic;
                          signal intrpt : IN dlx_nibble;
                          INT : INOUT dlx_nibble);

  -----------------------------------------------------------------
  -- procedure for checking the halt signal and freezing the processor 
  -----------------------------------------------------------------
  procedure check_halt (signal halt     : IN std_logic;
                        signal addr_bus : OUT dlx_address;
			signal data_bus : INOUT dlx_word;
			signal rw       : OUT std_logic;
			signal enable   : OUT dlx_nibble;
			--
			DEBUG     : IN boolean;
			tpd_behav : IN time);
  
    -----------------------------------------------------------------
    -- procedure for checking errors and exceptions 
    -----------------------------------------------------------------
    procedure exc_check (to_check : in std_logic;
                         p_exc : inout boolean);

    -----------------------------------------------------------------
    -- procedure for checking priviledge violations 
    -----------------------------------------------------------------
    procedure priv_check (adr_msb : in std_logic;
                          s_bit : in std_logic;
                          PRIV : inout std_logic;
                          p_exc : inout boolean);

    -----------------------------------------------------------------
    -- procedure for checking address alignment violations 
    -----------------------------------------------------------------
    procedure adr_check (adr_ls2 : in std_logic_vector(1 downto 0);
                         data_width : mem_access_type;
                         to_set : inout std_logic;
                         p_exc : inout boolean);

END behav_procedures_4;

      


