;  ###----------------------------------------------------------------###
;  #									#
;  # file	: loadstore      					#
;  # date	: Feb 22, 1995  					#
;  # descr.	: test load and store instructions			#
;  #									#
;  ###----------------------------------------------------------------###


		org	X"8000_0000"
		start	init

mem_base	equ 	X"9000_0000"
word		equ	X"0123_4567"
half0		equ	X"7fff"
half1		equ	X"fa51"
zext_half0	equ	X"0000_7fff"
zext_half1	equ	X"ffff_fa51"
byte0		equ	X"23"
byte1		equ	X"7f"
byte2		equ	X"ab"
byte3		equ	X"fe"
zext_byte0	equ	X"0000_0023"
zext_byte1	equ	X"0000_007f"
zext_byte2	equ	X"0000_00ab"
zext_byte3	equ	X"0000_00fe"

init:
		liw 	r30, mem_base
		clr	r29	
	
		liw	r1, word	; check word access immed. index
		sw.i	0(r30), r1
		lw.i	r2, 0(r30)
		seq	r3, r1, r2
		bnez	r3, cont_1

error_1		nop
		j	error_1		; error: endless loop 

cont_1		liw	r1, word	; check word access reg. index
		sw	r29(r30), r1
		lw	r2, r29(r30)
		seq	r3, r1, r2
		bnez	r3, cont_2
		
error_2		nop
		j	error_2		; error: endless loop 

cont_2		liu	r1, half0	; check half access immed index
		sh.i	4(r30), r1      
		liu 	r2, half1
		sh.i	6(r30), r2
		lhu.i	r3, 4(r30)
		lhu.i	r4, 6(r30)
		liw	r5, zext_half0
		liw	r6, zext_half1
		seq	r7, r5, r3
		beqz	r7, error_3
		seq	r7, r6, r4
		bnez	r7, cont_3				
		
error_3		nop
		j	error_3		; error: endless loop 

cont_3		liu	r1, half0	; check half access reg. index
		liu	r28, 4
		liu	r29, 6
		sh	r28(r30), r1      
		liu 	r2, half1
		sh	r29(r30), r2
		lhu	r3, r28(r30)
		lhu	r4, r29(r30)
		liw	r5, zext_half0
		liw	r6, zext_half1
		seq	r7, r5, r3
		beqz	r7, error_4
		seq	r7, r6, r4
		bnez	r7, cont_4				

error_4		nop
		j	error_2		; error: endless loop 

cont_4		liu	r1, byte0	; check byte access
		sb.i	12(r30), r1
		liu	r2, byte1
		sb.i	13(r30), r2
		liu	r3, byte2
		sb.i	14(r30), r3
		liu	r4, byte3
		sb.i	15(r30), r4
		lbu.i	r5, 12(r30)
		lbu.i	r6, 13(r30)
		lbu.i	r7, 14(r30)
		lbu.i	r8, 15(r30)
		liw	r9, zext_byte0
		liw	r10, zext_byte1
		liw	r11, zext_byte2
		liw	r12, zext_byte3
		seq	r13, r5, r9
		beqz	r13, error_5
		seq	r13, r6, r10
		beqz	r13, error_5
		seq	r13, r7, r11
		beqz	r13, error_5
		seq	r13, r8, r12
		bnez	r13, cont_5

error_5		nop
		j	error_3		; error: endless loop 
			        
cont_5		liu	r1, byte0	; check byte access
		liu	r26, 12
		liu	r27, 13
		liu	r28, 14
		liu	r29, 15
		sb	r26(r30), r1
		liu	r2, byte1
		sb	r27(r30), r2
		liu	r3, byte2
		sb	r28(r30), r3
		liu	r4, byte3
		sb	r29(r30), r4
		lbu	r5, r26(r30)
		lbu	r6, r27(r30)
		lbu	r7, r28(r30)
		lbu	r8, r29(r30)
		liw	r9, zext_byte0
		liw	r10, zext_byte1
		liw	r11, zext_byte2
		liw	r12, zext_byte3
		seq	r13, r5, r9
		beqz	r13, error_5
		seq	r13, r6, r10
		beqz	r13, error_5
		seq	r13, r7, r11
		beqz	r13, error_5
		seq	r13, r8, r12
		bnez	r13, cont_6

error_6		nop
		j	error_6		; error: endless loop 
	
cont_6		j	init		;restart

                end
