;  ##########################################################
;  # DLX_ASM testfile for DLX validation                    #
;  #                                                        #
;  # file	: exc1.asm				    #
;  # testcase	: test exception handling 		    #
;  ##########################################################

; exception handling routine (system.asm) returns to next intsruction

		org	X"8000_0000"
		start	init

init:
		;j	cont_1
		;test instrcution address violation (IAV)

		add.i	r20, r0, X"0003"
		jr	r20			

		jalr	r20

		j	X"8000_9875"

		jal	X"FFFF_FFFF"

		beqz	r0, X"2345"

		bnez	r20, X"00ff"

		trap	X"3FFF_7777"

cont_1:
		;j	cont_2
		;test data address violation (DAV)        

		liw	r20, X"9000_0000"
		lis	r21, X"ffff"
		lis	r1, X"0001"
		lis	r2, X"0002"
		lis	r5, X"0005"
		lis	r6, X"0006"

		lw.i	r22, 2(r20)
		lh.i	r22, 1(r20)

		sw.i	6(r20),	r21
		sh.i	5(r20),	r21

		lw	r22, r2(r20)
		lh	r22, r1(r20)

		sw	r6(r20),r21
		sh	r5(r20),r21

cont_2:
		;j	cont_3
		;test arithmetik overflow (OVAR)     

		lhi	r1, X"8000"
		liw	r2, X"FFFF_FFFF"
		lis	r3, X"0001"

		add	r5, r1, r2	;overflow 
		add.i	r5, r1, X"FFFF"	;"

		sub	r5, r1, r3	;"
		sub.i	r5, r1, X"0001"	;"

cont_3:
		;j	cont_4
		;test address overflow (OVAD)     

		nop

cont_4:
		;j	cont_5     
		;test priviledge violation (PRIV)     
		
                lis	r1, 1

		j 	X"3fff_0000"	;violation
		jal	X"3fff_0000"	;violation
		jr	r0		;violation
		jalr	r0		;violation
		beqz	r0, X"8000"	;violation
		bnez	r1, X"8000"	;violation

		liw	r20, X"1000_0000"
		lis	r21, X"ffff"
		lis	r1, X"0001"
		lis	r2, X"0002"
		lis	r3, X"0004"

		lw.i	r22, 0(r20)	;violation
		lh.i	r22, 2(r20)	;violation
		lb.i	r22, 1(r20)	;violation

		sw.i	4(r20),	r21	;violation
		sh.i	6(r20),	r21	;violation
		sb.i	7(r20),	r21	;violation

		lw	r22, r3(r20)	;violation
		lh	r22, r2(r20)	;violation
		lb	r22, r1(r20)	;violation

		sw	r3(r20), r21	;violation
		sh	r2(r20), r21	;violation
		sb	r1(r20), r21	;violation
cont_5:
		movi2s	icr, r1		;violation
		movs2i  r1, tbr		;"
		rfe			;"

finish:
		j 	finish

		end

		
