;  ###----------------------------------------------------------------###
;  #									#
;  # file	: arith.asm      					#
;  # date	: Feb 22, 1995  					#
;  # descr.	: test arithmetic instructions     			#
;  #									#
;  ###----------------------------------------------------------------###


		org	X"8000_0000"
value1		equ	X"0005"
value2		equ 	X"7ff0"
value3		equ	X"fff0"
value4		equ	X"8000"



		start	init

init:		
		lis	r1, value1
		lis	r2, value2
		lis	r3, value3
		lis	r4, value4
		
		add	r8, r1, r2	;0005+7ff0
		seq.i	r9, r8, X"7ff5"
		beqz	r9, error
		add	r8, r8, r3	;7ff5+(-0010)
		seq.i	r9, r8, X"7fe5"
		beqz	r9, error
		add	r8, r8, r4	;7fe5+(-8000)
		seq.i	r9, r8, X"ffe5"
		beqz	r9, error

		add.i	r8, r1, value2	;0005+7ff0
		seq.i	r9, r8, X"7ff5"
		beqz	r9, error
		add.i	r8, r8, value3	;7ff5+(-0010)
		seq.i	r9, r8, X"7fe5"
		beqz	r9, error
		add.i	r8, r8, value4	;7fe5+(-8000)
		seq.i	r9, r8, X"ffe5"
		beqz	r9, error
							;sub/subi
		sub	r8, r1, r2	;0005-7ff0
		seq.i	r9, r8, X"8015"
		beqz	r9, error
		sub	r8, r8, r3	;-(7feb)-(-0010)
		seq.i	r9, r8, X"8025"
		beqz	r9, error
		sub	r8, r8, r4	;-(7fdb)-(-8000)
		seq.i	r9, r8, X"0025"
		beqz	r9, error

		sub.i	r8, r1, value2	;0005-7ff0
		seq.i	r9, r8, X"8015"
		beqz	r9, error
		sub.i	r8, r8, value3	;-(7feb)-(-0010)
		seq.i	r9, r8, X"8025"
		beqz	r9, error
		sub.i	r8, r8, value4	;-(7fdb)-(-8000)
		seq.i	r9, r8, X"0025"
		beqz	r9, error

		j	ok		;test ok
			        
		org 	X"0000_1000"
error		nop
		j	error

		org 	X"0000_2000"
ok		j	ok

		end
