/*===========================+==========================================*/
/*									*/
/* file		: dxlasm_text.h						*/
/* date		: Sept 30 1995						*/
/* version	: v1.1							*/
/* author	: Martin Gumm    					*/
/* description	: DLX assembler - global text constants          	*/
/* comment      :  modified version of the DLX assembler                */
/*									*/
/*======================================================================*/

char *vhdl_file_header_1[]= 
{
  "--------------------------------------------------------------------------",
  "--  DLX PROCESSOR MODEL SUITE",
  "--  Copyright (C) 1995, Martin Gumm",
  "--  University of Stuttgart / Department of Computer Science / IPVR-ISE",
  "--------------------------------------------------------------------------",
  "--  This program is free software; you can redistribute it and/or modify",
  "--  it under the terms of the GNU General Public License as published by",
  "--  the Free Software Foundation; either version 1, or (at your option)",
  "--  any later version.",
  "--",
  "--  This program is distributed in the hope that it will be useful,",
  "--  but WITHOUT ANY WARRANTY; without even the implied warranty of",
  "--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the",
  "--  GNU General Public License for more details.",
  "--------------------------------------------------------------------------",
  "",
  "--------------------------------------------------------------------------",
  "--  Architecture declaration for the rom",
  "--    generated by the DLX_ASM assembler v1.0",
  "--    (C) v1.1 M.Gumm / (C) v0.1 P. Bazrgan Sabet",
  "--",
  NULL
};

char *vhdl_file_header_2[]= 
{
  "begin",
  " ",
  "-- word addressable rom (size 64Kbyte : 16 bit address)",
  " ",
  "  process",
  "    variable address : natural;",
  "  begin",
  "    --",
  "    -- initialize outputs",
  "    --",
  "    d_bus <= (others => 'Z') after tpd;",
  "    ready <= 'Z' after tpd;",
  "      --",
  "      -- wait until rom is enabled",
  "      --",
  "      wait until Is_1H(enable);",
  "      ready <= '0' after tpd;",
  "      --",
  "      -- decode address and perform command if selected",
  "      --",
  "      address := sv_to_natural(a_bus);",
  "      wait for tac; 			-- read access time",
  "      case address is",
  NULL
};

char *vhdl_file_foot[]= 
{
  "        when others   => d_bus <= (others => 'X');",
  "      end case;",
  "      ready <= '1' after tpd;",
  "      --",
  "      -- wait for acceptance of data",
  "      --",
  "      wait until Is_0L(enable);",
  " ",
  "  end process;",
  " ",
  NULL
};

char *banner[]= 
{
  " ",
  "+-----------------------------------------------------------------+",
  "|  DDDDD    LL      XX   XX           AAA     SSSSSS   MMM   MMM  |",
  "|  DD  DD   LL       XX XX           AA AA    SS       MMMM MMMM  |",
  "|  DD   DD  LL        XXX     ===   AAAAAAA   SSSSSS   MM MMM MM  |",
  "|  DD  DD   LL       XX XX          AA   AA       SS   MM     MM  |",
  "|  DDDDD    LLLLL   XX   XX         AA   AA   SSSSSS   MM     MM  |",
  "+-----------------------------------------------------------------+",
  "|  ORIGINAL VERSION v0.1                                          |",
  "|  by Pirouz BAZARGAN SABET                                       |",
  "|  Jan 20 1994					             |",
  "|  (C) MASI/IBP/CAO-VLSI                                          |",
  "+-----------------------------------------------------------------+",
  "|  MODIFIED VERSION v1.1                                          |",
  "|  -> complete DLX instruction set and ...                        |",
  "|  -> instruction coding as defined by Hennessy/Patterson         |",
  "|                                                                 |",
  "|  by Martin GUMM / IPVR-ISE                                      |",
  "|  Nov 28 1995                                                    |",
  "|  for the use within the                                         |",
  "|  VLSI CAD COURSE                                                |",
  "|  (C) University of Stuttgart / Dept. of Computer Science        |",
  "+-----------------------------------------------------------------+",
  " ",
  NULL
};

char *usage[]= 
{
  "usage : dlx_asm <-s|u|i|f> <assembly_file> <vhdl_file_ext>",
  " ",
  "options:",
  " -s   include only signed integer instructions",
  " -u   include \"-s\"-instructions and instructions for unsigned",
  "       integer operations except multipl. and division operators",
  " -i   include \"-s\" and \"-u\"-instructions and",
  "       multiplication and division operators",
  " -f   include \"-s\" and \"-u\"and \"-i\"-instructions and",
  "       all floating point instructions",
  " ", 
  "example: dlx_asm -u test.asm test",
  "   -> the input file \"test.asm\" is read",
  "   -> instructions for unsigned integer operations are allowed",
  "   -> the output file \"rom-behaviour_test.vhd\" is generated",
  " ",
  NULL
};




