;  ##########################################################
;  # DLX_ASM testfile for DLX validation                    #
;  #                                                        #
;  # file	: sys.asm				    #
;  # testcase	: startup routine                           #
;  #              interrupt and exception handler           #
;  #              special trap handler                      #
;  #              load timer handler                        #
;  ##########################################################

	trap_handler	equ	X"0000_1000"
	user_t_handl1	equ	X"0000_2000"
	user_t_handl2	equ	X"0000_3000"
        hang_up_base	equ	X"0000_8000"
	user_start	equ	X"8000_0000"	

; #####################################
; Initialization routine
; #####################################

	org	X"0000_0000"
	start	init

init:	
	        liw	r1, trap_handler
		movi2s	tbr, r1			;set trap handler base address
	
		liw	r1, user_start
		movi2s	iar, r1			;set address for rfe
					
		clr	r1			; set r1 to zero
		clr	r2			; set r2 to zero
		clr	r3			; set r3 to zero
		clr	r4			; set r4 to zero
		clr	r5			; set r5 to zero
		clr	r6			; set r6 to zero
		clr	r7			; set r7 to zero
		clr	r8			; set r8 to zero
		clr	r9			; set r9 to zero
		clr	r10			; set r10 to zero
		clr	r11			; set r11 to zero
		clr	r12			; set r12 to zero
		clr	r13			; set r13 to zero
		clr	r14			; set r14 to zero
		clr	r15			; set r15 to zero
		clr	r16			; set r16 to zero
		clr	r17			; set r17 to zero
		clr	r18			; set r18 to zero
		clr	r19			; set r19 to zero
		clr	r20			; set r20 to zero
		clr	r21			; set r21 to zero
		clr	r22			; set r22 to zero
		clr	r23			; set r23 to zero
		clr	r24			; set r24 to zero
		clr	r25			; set r25 to zero
		clr	r26			; set r26 to zero
		clr	r27			; set r27 to zero
		clr	r28			; set r28 to zero
		clr	r29			; set r29 to zero
		clr	r30			; set r30 to zero
		clr	r31			; set r31 to zero

		rfe				;jump to user program	

; #####################################
; trap handle routine
; #####################################

	org	trap_handler

handle_rout:
                movs2i	r30, icr		;load from ICR
		and.i	r30, r30, X"00fe"	;clear all bits except exception bits
		bnez	r30, exc_handle		;exception ?

; ######################################

int_handle:
		movs2i	r30, icr		;reload from ICR
		srl.i	r30, r30, 28		;intrpt bits to lsb
		sle.i	r29, r30, X"0001"	;interrupt3?
		beqz	r29, no_int3

; intrpt 3 not connected

int3:
		j	int_return		
no_int3:
		sle.i	r29, r30, X"0002"	; interrupt2?
		beqz	r29, no_int2				

; intrpt 2 not connected

int2:		
		j	int_return		
no_int2:
		sle.i	r29, r30, X"0004"	; interrupt1?
		beqz	r29, int0

; timer interrupt on line intrpt 1 :
; read out timer 1 and deactivate timer 1

int1:
		lhi	r30, X"7000"		;basic address timer
		lw.i	r29, 0(r30)		;read timer statusword
		lis	r28, X"0015"
		sll.i	r28, r28, 26
		xor	r29, r29, r28		;del. bit int1,mask1,count1
		sw.i	0(r30), r29		;write back statusword
		j	int_return		;return from interrupt

; timer interrupt on line intrpt 0 :
; read out timer 1 and deactivate timer 0

int0:
		lhi	r30, X"7000"		;basic address timer
		lw.i	r29, 0(r30)		;read timer statusword
		lis	r28, X"0015"
		sll.i	r28, r28, 27
		xor	r29, r29, r28		;del. bit int0,mask0,count0
		sw.i	0(r30), r29		;write back statusword
		j	int_return		;return from interrupt

int_return:
		movs2i	r30, icr		;reload icr content
		lis	r29, X"ffff"
		srl.i	r29, r29, 4 		;r29 = 0fff_ffff
		and	r30, r30, r29		
		movi2s	icr, r30		;clear interrupt bits	
		rfe                             ;(S bit rests unchanged)

; ################################################################

exc_handle:
		seq.i	r29, r30, X"0002"	
		beqz	r29, no_ill_opc		;illegal opcode ?
		j	hang_up

no_ill_opc:
 		sle.i	r29, r30, X"0004"	
		beqz	r29, no_ill_rraf	;illegal reg-reg ALU function ?
		j	hang_up

no_ill_rraf:
		sle.i	r29, r30, X"0008"
		beqz	r29, no_ill_iadr	;illegal instruction address ?
		j	hang_up
 
no_ill_iadr:
		sle.i	r29, r30, X"0010"
		beqz	r29, no_ill_dadr	;illegal data address ?
		j	hang_up


no_ill_dadr:
		sle.i	r29, r30, X"0020"
		beqz	r29, no_adr_ovf		;address overflow ?
		j	hang_up

no_adr_ovf:
		seq.i	r29, r30, X"0080"
		beqz	r29, no_priv_viol	;priviledge violation ?
		j	hang_up

no_priv_viol:
						;=> arithmetic overflow !
						;iar contains address of the
						; succeeding instr after faulty
						; instruction
						;exception bits are cleared
						; by shifting	
		rfe				;resume		
					
		org	hang_up_base
hang_up:
		nop                             
		;j	hang_up                 ;normally no resume !
		j 	no_priv_viol		; resume for test purposes
	
; ################################################################
		org	user_t_handl1
trap_test:					;this is an exmaple for a
		movs2i	r30, iar		;  software trap started by 
		mov	r29, r30		;  a user program
		movi2s	iar, r29		;(do nothing serious)
		
		rfe				;user started trap
						; -> s bit was zero before 


; ################################################################
		org	user_t_handl2

;--------------------------------------------------------------------------
;-- programming model of the timer module:
;--
;-- address 0 : timer status word (32 bit)
;-- address 4 : counter_0 (16 bit downcount) read/write
;-- address 8 : counter_1 (16 bit downcount) read/write
;--
;-- counter:  address  | address+1 | address+2 | address+3 |
;--           ----------------------------------------------
;--           high byte| low byte  |      (unused)         |
;--
;-- timer status word:
;-- 
;-- --------------------------------------------------------------------
;-- Bit no.  |   0   |   1   |  2  |  3  |  4   |  5   |  6   |   7    |
;-- function |intrpt0|intrpt1|mask0|mask1|count0|count1|double|sync_res|
;-- --------------------------------------------------------------------
;-- Bit no.  |            8  -  15   (8 bit value for n)               |
;-- function |        delay every count event by n clock cycles        |
;-- --------------------------------------------------------------------
;-- Bit no.  |                    16 -  31                             |
;-- function |                    (unused)                             |
;-- --------------------------------------------------------------------
;--
;-- intrptx : '1': if interrupt has occurred after last reset
;--                (must be cleared to reactivate interrupt outputs)
;-- maskx   : '1': enable interrup output x (active when counter x is zero)
;-- countx  : '1': enable counting for counter x (must be zero when loading)
;-- double  : '1': connect counter 0 and 1
;--                (counter 1 is high word of 64 bit counter)
;-- sync_res: '1': reset all registers synchronous with next clock cycle
;--
;-- irq_out(0) : '1' if counter_0 becomes zero and interrupt 0 is enabled
;--              or
;--              '1' if counter_1 & counter_0 become zero and interrupt 0
;--              is enabled
;-- irq_out(1) : '1' if counter_1 becomes zero and interrupt 1 is enabled
;--------------------------------------------------------------------------

reset_timer:
		lhi	r30, X"7000"	;timer basic address
		lhi	r29, X"0100"	;timer reset bit
		sw.i	0(r30), r29	;synchr. reset of timer
		rfe			;user started trap -> s bit was zero before 

		org	user_t_handl2 + X"0100"
load_timer0:
		lhi	r30, X"7000"	;timer basic address
		sll.i	r29, r29, 16    ;value for counter0 was in r29(16:31)
		sw.i	4(r30), r29	;load counter0		
		rfe			;user started trap -> s bit was zero before 

		org	user_t_handl2 + X"0200"
load_timer1:
		lhi	r30, X"7000"	;timer basic address
		sll.i	r29, r29, 16    ;value for counter1 was in r29(16:31)
		sw.i	8(r30), r29	;load counter1
		rfe			;user started trap -> s bit was zero before 

		org	user_t_handl2 + X"0300"
enable_intrpts:
		lhi	r29, X"0f00"	
		movs2i	r30, icr
		or	r30, r30, r29
		movi2s	icr, r30	;set all intrpt-mask bits in icr
		rfe			;user started trap -> s bit was zero before 

		org	user_t_handl2 + X"0400"
start_timer:
		lhi	r30, X"7000"	;timer basic address
		lhi	r29, X"3c00"	
		sw.i	0(r30), r29	;enable interrupt0&1
					;start counter0&1
					;count every cycle	
		rfe			;user started trap -> s bit was zero before 
		

end








